/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.impl.LogoutRequestUnmarshaller;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidatorParameters;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestValidatorParametersResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2MessageBindingUtils;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2Utils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class OpenSamlLogoutRequestValidatorParametersResolver
implements Saml2LogoutRequestValidatorParametersResolver {
    private RequestMatcher requestMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/logout/saml2/slo/{registrationId}"), new AntPathRequestMatcher("/logout/saml2/slo")});
    private final RelyingPartyRegistrationRepository registrations;
    private final ParserPool parserPool;
    private final LogoutRequestUnmarshaller unmarshaller;

    public OpenSamlLogoutRequestValidatorParametersResolver(RelyingPartyRegistrationRepository registrations) {
        Assert.notNull((Object)registrations, (String)"relyingPartyRegistrationRepository cannot be null");
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.parserPool = registry.getParserPool();
        this.unmarshaller = (LogoutRequestUnmarshaller)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(LogoutRequest.DEFAULT_ELEMENT_NAME);
        this.registrations = registrations;
    }

    @Override
    public Saml2LogoutRequestValidatorParameters resolve(HttpServletRequest request, Authentication authentication) {
        if (request.getParameter("SAMLRequest") == null) {
            return null;
        }
        RequestMatcher.MatchResult result = this.requestMatcher.matcher(request);
        if (!result.isMatch()) {
            return null;
        }
        String registrationId = this.getRegistrationId(result, authentication);
        if (registrationId == null) {
            return this.logoutRequestByEntityId(request, authentication);
        }
        return this.logoutRequestById(request, authentication, registrationId);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    private String getRegistrationId(RequestMatcher.MatchResult result, Authentication authentication) {
        String registrationId = (String)result.getVariables().get("registrationId");
        if (registrationId != null) {
            return registrationId;
        }
        if (authentication == null) {
            return null;
        }
        Object object = authentication.getPrincipal();
        if (object instanceof Saml2AuthenticatedPrincipal) {
            Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)object;
            return principal.getRelyingPartyRegistrationId();
        }
        return null;
    }

    private Saml2LogoutRequestValidatorParameters logoutRequestById(HttpServletRequest request, Authentication authentication, String registrationId) {
        RelyingPartyRegistration registration = this.registrations.findByRegistrationId(registrationId);
        if (registration == null) {
            throw new Saml2AuthenticationException(new Saml2Error("relying_party_registration_not_found", "registration not found"), "registration not found");
        }
        return this.logoutRequestByRegistration(request, registration, authentication);
    }

    private Saml2LogoutRequestValidatorParameters logoutRequestByEntityId(HttpServletRequest request, Authentication authentication) {
        String serialized = request.getParameter("SAMLRequest");
        byte[] b = Saml2Utils.samlDecode(serialized);
        LogoutRequest logoutRequest = this.parse(this.inflateIfRequired(request, b));
        String issuer = logoutRequest.getIssuer().getValue();
        RelyingPartyRegistration registration = this.registrations.findUniqueByAssertingPartyEntityId(issuer);
        return this.logoutRequestByRegistration(request, registration, authentication);
    }

    private Saml2LogoutRequestValidatorParameters logoutRequestByRegistration(HttpServletRequest request, RelyingPartyRegistration registration, Authentication authentication) {
        if (registration == null) {
            return null;
        }
        Saml2MessageBinding saml2MessageBinding = Saml2MessageBindingUtils.resolveBinding(request);
        registration = this.fromRequest(request, registration);
        String serialized = request.getParameter("SAMLRequest");
        Saml2LogoutRequest logoutRequest = Saml2LogoutRequest.withRelyingPartyRegistration(registration).samlRequest(serialized).relayState(request.getParameter("RelayState")).binding(saml2MessageBinding).location(registration.getSingleLogoutServiceLocation()).parameters(params -> params.put("SigAlg", request.getParameter("SigAlg"))).parameters(params -> params.put("Signature", request.getParameter("Signature"))).parametersQuery(params -> request.getQueryString()).build();
        return new Saml2LogoutRequestValidatorParameters(logoutRequest, registration, authentication);
    }

    private String inflateIfRequired(HttpServletRequest request, byte[] b) {
        if (HttpMethod.GET.equals((Object)request.getMethod())) {
            return Saml2Utils.samlInflate(b);
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    private LogoutRequest parse(String request) throws Saml2Exception {
        try {
            Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(request.getBytes(StandardCharsets.UTF_8)));
            Element element = document.getDocumentElement();
            return (LogoutRequest)this.unmarshaller.unmarshall(element);
        }
        catch (Exception ex) {
            throw new Saml2Exception("Failed to deserialize LogoutRequest", ex);
        }
    }

    private RelyingPartyRegistration fromRequest(HttpServletRequest request, RelyingPartyRegistration registration) {
        RelyingPartyRegistrationPlaceholderResolvers.UriResolver uriResolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
        String entityId = uriResolver.resolve(registration.getEntityId());
        String logoutLocation = uriResolver.resolve(registration.getSingleLogoutServiceLocation());
        String logoutResponseLocation = uriResolver.resolve(registration.getSingleLogoutServiceResponseLocation());
        return registration.mutate().entityId(entityId).singleLogoutServiceLocation(logoutLocation).singleLogoutServiceResponseLocation(logoutResponseLocation).build();
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

