/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSamlSigningUtils;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2Utils;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class OpenSamlLogoutRequestResolver {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final LogoutRequestMarshaller marshaller;
    private final IssuerBuilder issuerBuilder;
    private final NameIDBuilder nameIdBuilder;
    private final SessionIndexBuilder sessionIndexBuilder;
    private final LogoutRequestBuilder logoutRequestBuilder;
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;

    OpenSamlLogoutRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.marshaller = (LogoutRequestMarshaller)registry.getMarshallerFactory().getMarshaller(LogoutRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.marshaller, (String)"logoutRequestMarshaller must be configured in OpenSAML");
        this.logoutRequestBuilder = (LogoutRequestBuilder)registry.getBuilderFactory().getBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.logoutRequestBuilder, (String)"logoutRequestBuilder must be configured in OpenSAML");
        this.issuerBuilder = (IssuerBuilder)registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.issuerBuilder, (String)"issuerBuilder must be configured in OpenSAML");
        this.nameIdBuilder = (NameIDBuilder)registry.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.nameIdBuilder, (String)"nameIdBuilder must be configured in OpenSAML");
        this.sessionIndexBuilder = (SessionIndexBuilder)registry.getBuilderFactory().getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.sessionIndexBuilder, (String)"sessionIndexBuilder must be configured in OpenSAML");
    }

    Saml2LogoutRequest resolve(HttpServletRequest request, Authentication authentication) {
        return this.resolve(request, authentication, (registration, logoutRequest) -> {});
    }

    Saml2LogoutRequest resolve(HttpServletRequest request, Authentication authentication, BiConsumer<RelyingPartyRegistration, LogoutRequest> logoutRequestConsumer) {
        String xml;
        String registrationId = this.getRegistrationId(authentication);
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, registrationId);
        if (registration == null) {
            return null;
        }
        if (registration.getAssertingPartyDetails().getSingleLogoutServiceLocation() == null) {
            return null;
        }
        LogoutRequest logoutRequest = this.logoutRequestBuilder.buildObject();
        logoutRequest.setDestination(registration.getAssertingPartyDetails().getSingleLogoutServiceLocation());
        Issuer issuer = this.issuerBuilder.buildObject();
        issuer.setValue(registration.getEntityId());
        logoutRequest.setIssuer(issuer);
        NameID nameId = this.nameIdBuilder.buildObject();
        nameId.setValue(authentication.getName());
        logoutRequest.setNameID(nameId);
        if (authentication.getPrincipal() instanceof Saml2AuthenticatedPrincipal) {
            Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)authentication.getPrincipal();
            for (String index : principal.getSessionIndexes()) {
                SessionIndex sessionIndex = this.sessionIndexBuilder.buildObject();
                sessionIndex.setSessionIndex(index);
                logoutRequest.getSessionIndexes().add(sessionIndex);
            }
        }
        logoutRequestConsumer.accept(registration, logoutRequest);
        if (logoutRequest.getID() == null) {
            logoutRequest.setID("LR" + UUID.randomUUID());
        }
        String relayState = UUID.randomUUID().toString();
        Saml2LogoutRequest.Builder result = Saml2LogoutRequest.withRelyingPartyRegistration(registration).id(logoutRequest.getID());
        if (registration.getAssertingPartyDetails().getSingleLogoutServiceBinding() == Saml2MessageBinding.POST) {
            xml = this.serialize(OpenSamlSigningUtils.sign(logoutRequest, registration));
            String samlRequest = Saml2Utils.samlEncode(xml.getBytes(StandardCharsets.UTF_8));
            return result.samlRequest(samlRequest).relayState(relayState).build();
        }
        xml = this.serialize(logoutRequest);
        String deflatedAndEncoded = Saml2Utils.samlEncode(Saml2Utils.samlDeflate(xml));
        result.samlRequest(deflatedAndEncoded);
        OpenSamlSigningUtils.QueryParametersPartial partial = OpenSamlSigningUtils.sign(registration).param("SAMLRequest", deflatedAndEncoded).param("RelayState", relayState);
        return result.parameters(params -> params.putAll(partial.parameters())).build();
    }

    private String getRegistrationId(Authentication authentication) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Attempting to resolve registrationId from " + authentication));
        }
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof Saml2AuthenticatedPrincipal) {
            return ((Saml2AuthenticatedPrincipal)principal).getRelyingPartyRegistrationId();
        }
        return null;
    }

    private String serialize(LogoutRequest logoutRequest) {
        try {
            Element element = this.marshaller.marshall((XMLObject)logoutRequest);
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (MarshallingException ex) {
            throw new Saml2Exception(ex);
        }
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

