/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class DefaultRelyingPartyRegistrationResolver
implements Converter<HttpServletRequest, RelyingPartyRegistration>,
RelyingPartyRegistrationResolver {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final char PATH_DELIMITER = '/';
    private final RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private final RequestMatcher registrationRequestMatcher = new AntPathRequestMatcher("/**/{registrationId}");

    public DefaultRelyingPartyRegistrationResolver(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        Assert.notNull((Object)relyingPartyRegistrationRepository, (String)"relyingPartyRegistrationRepository cannot be null");
        this.relyingPartyRegistrationRepository = relyingPartyRegistrationRepository;
    }

    public RelyingPartyRegistration convert(HttpServletRequest request) {
        return this.resolve(request, null);
    }

    @Override
    public RelyingPartyRegistration resolve(HttpServletRequest request, String relyingPartyRegistrationId) {
        if (relyingPartyRegistrationId == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempting to resolve from " + this.registrationRequestMatcher + " since registrationId is null"));
            }
            relyingPartyRegistrationId = (String)this.registrationRequestMatcher.matcher(request).getVariables().get("registrationId");
        }
        if (relyingPartyRegistrationId == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Returning null registration since registrationId is null");
            }
            return null;
        }
        RelyingPartyRegistration relyingPartyRegistration = this.relyingPartyRegistrationRepository.findByRegistrationId(relyingPartyRegistrationId);
        if (relyingPartyRegistration == null) {
            return null;
        }
        String applicationUri = DefaultRelyingPartyRegistrationResolver.getApplicationUri(request);
        Function<String, String> templateResolver = this.templateResolver(applicationUri, relyingPartyRegistration);
        String relyingPartyEntityId = templateResolver.apply(relyingPartyRegistration.getEntityId());
        String assertionConsumerServiceLocation = templateResolver.apply(relyingPartyRegistration.getAssertionConsumerServiceLocation());
        String singleLogoutServiceLocation = templateResolver.apply(relyingPartyRegistration.getSingleLogoutServiceLocation());
        String singleLogoutServiceResponseLocation = templateResolver.apply(relyingPartyRegistration.getSingleLogoutServiceResponseLocation());
        return RelyingPartyRegistration.withRelyingPartyRegistration(relyingPartyRegistration).entityId(relyingPartyEntityId).assertionConsumerServiceLocation(assertionConsumerServiceLocation).singleLogoutServiceLocation(singleLogoutServiceLocation).singleLogoutServiceResponseLocation(singleLogoutServiceResponseLocation).build();
    }

    private Function<String, String> templateResolver(String applicationUri, RelyingPartyRegistration relyingParty) {
        return template -> DefaultRelyingPartyRegistrationResolver.resolveUrlTemplate(template, applicationUri, relyingParty);
    }

    private static String resolveUrlTemplate(String template, String baseUrl, RelyingPartyRegistration relyingParty) {
        if (template == null) {
            return null;
        }
        String entityId = relyingParty.getAssertingPartyDetails().getEntityId();
        String registrationId = relyingParty.getRegistrationId();
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)baseUrl).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        Object path = uriComponents.getPath();
        if (StringUtils.hasLength((String)path) && ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        uriVariables.put("basePath", path != null ? path : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        uriVariables.put("entityId", StringUtils.hasText((String)entityId) ? entityId : "");
        uriVariables.put("registrationId", StringUtils.hasText((String)registrationId) ? registrationId : "");
        return UriComponentsBuilder.fromUriString((String)template).buildAndExpand(uriVariables).toUriString();
    }

    private static String getApplicationUri(HttpServletRequest request) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        return uriComponents.toUriString();
    }
}

