/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestUnmarshaller;
import org.opensaml.saml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutResponseMarshaller;
import org.opensaml.saml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSamlSigningUtils;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2Utils;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class OpenSamlLogoutResponseResolver {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ParserPool parserPool;
    private final LogoutRequestUnmarshaller unmarshaller;
    private final LogoutResponseMarshaller marshaller;
    private final LogoutResponseBuilder logoutResponseBuilder;
    private final IssuerBuilder issuerBuilder;
    private final StatusBuilder statusBuilder;
    private final StatusCodeBuilder statusCodeBuilder;
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;

    OpenSamlLogoutResponseResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.parserPool = registry.getParserPool();
        this.unmarshaller = (LogoutRequestUnmarshaller)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(LogoutRequest.DEFAULT_ELEMENT_NAME);
        this.marshaller = (LogoutResponseMarshaller)registry.getMarshallerFactory().getMarshaller(LogoutResponse.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.marshaller, (String)"logoutResponseMarshaller must be configured in OpenSAML");
        this.logoutResponseBuilder = (LogoutResponseBuilder)registry.getBuilderFactory().getBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.logoutResponseBuilder, (String)"logoutResponseBuilder must be configured in OpenSAML");
        this.issuerBuilder = (IssuerBuilder)registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.issuerBuilder, (String)"issuerBuilder must be configured in OpenSAML");
        this.statusBuilder = (StatusBuilder)registry.getBuilderFactory().getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.statusBuilder, (String)"statusBuilder must be configured in OpenSAML");
        this.statusCodeBuilder = (StatusCodeBuilder)registry.getBuilderFactory().getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.statusCodeBuilder, (String)"statusCodeBuilder must be configured in OpenSAML");
    }

    Saml2LogoutResponse resolve(HttpServletRequest request, Authentication authentication) {
        return this.resolve(request, authentication, (registration, logoutResponse) -> {});
    }

    Saml2LogoutResponse resolve(HttpServletRequest request, Authentication authentication, BiConsumer<RelyingPartyRegistration, LogoutResponse> logoutResponseConsumer) {
        String registrationId = this.getRegistrationId(authentication);
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, registrationId);
        if (registration == null) {
            return null;
        }
        if (registration.getAssertingPartyDetails().getSingleLogoutServiceResponseLocation() == null) {
            return null;
        }
        String serialized = request.getParameter("SAMLRequest");
        byte[] b = Saml2Utils.samlDecode(serialized);
        LogoutRequest logoutRequest = this.parse(this.inflateIfRequired(registration, b));
        LogoutResponse logoutResponse = this.logoutResponseBuilder.buildObject();
        logoutResponse.setDestination(registration.getAssertingPartyDetails().getSingleLogoutServiceResponseLocation());
        Issuer issuer = this.issuerBuilder.buildObject();
        issuer.setValue(registration.getEntityId());
        logoutResponse.setIssuer(issuer);
        StatusCode code = this.statusCodeBuilder.buildObject();
        code.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        Status status = this.statusBuilder.buildObject();
        status.setStatusCode(code);
        logoutResponse.setStatus(status);
        logoutResponse.setInResponseTo(logoutRequest.getID());
        if (logoutResponse.getID() == null) {
            logoutResponse.setID("LR" + UUID.randomUUID());
        }
        logoutResponseConsumer.accept(registration, logoutResponse);
        Saml2LogoutResponse.Builder result = Saml2LogoutResponse.withRelyingPartyRegistration(registration);
        if (registration.getAssertingPartyDetails().getSingleLogoutServiceBinding() == Saml2MessageBinding.POST) {
            String xml = this.serialize(OpenSamlSigningUtils.sign(logoutResponse, registration));
            String samlResponse = Saml2Utils.samlEncode(xml.getBytes(StandardCharsets.UTF_8));
            result.samlResponse(samlResponse);
            if (request.getParameter("RelayState") != null) {
                result.relayState(request.getParameter("RelayState"));
            }
            return result.build();
        }
        String xml = this.serialize(logoutResponse);
        String deflatedAndEncoded = Saml2Utils.samlEncode(Saml2Utils.samlDeflate(xml));
        result.samlResponse(deflatedAndEncoded);
        OpenSamlSigningUtils.QueryParametersPartial partial = OpenSamlSigningUtils.sign(registration).param("SAMLResponse", deflatedAndEncoded);
        if (request.getParameter("RelayState") != null) {
            partial.param("RelayState", request.getParameter("RelayState"));
        }
        return result.parameters(params -> params.putAll(partial.parameters())).build();
    }

    private String getRegistrationId(Authentication authentication) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Attempting to resolve registrationId from " + authentication));
        }
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof Saml2AuthenticatedPrincipal) {
            return ((Saml2AuthenticatedPrincipal)principal).getRelyingPartyRegistrationId();
        }
        return null;
    }

    private String inflateIfRequired(RelyingPartyRegistration registration, byte[] b) {
        if (registration.getSingleLogoutServiceBinding() == Saml2MessageBinding.REDIRECT) {
            return Saml2Utils.samlInflate(b);
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    private LogoutRequest parse(String request) throws Saml2Exception {
        try {
            Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(request.getBytes(StandardCharsets.UTF_8)));
            Element element = document.getDocumentElement();
            return (LogoutRequest)this.unmarshaller.unmarshall(element);
        }
        catch (Exception ex) {
            throw new Saml2Exception("Failed to deserialize LogoutRequest", ex);
        }
    }

    private String serialize(LogoutResponse logoutResponse) {
        try {
            Element element = this.marshaller.marshall((XMLObject)logoutResponse);
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (MarshallingException ex) {
            throw new Saml2Exception(ex);
        }
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

