/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;

public final class RelyingPartyRegistration {
    private final String registrationId;
    private final String entityId;
    private final String assertionConsumerServiceLocation;
    private final Saml2MessageBinding assertionConsumerServiceBinding;
    private final String singleLogoutServiceLocation;
    private final String singleLogoutServiceResponseLocation;
    private final Saml2MessageBinding singleLogoutServiceBinding;
    private final ProviderDetails providerDetails;
    private final List<org.springframework.security.saml2.credentials.Saml2X509Credential> credentials;
    private final Collection<Saml2X509Credential> decryptionX509Credentials;
    private final Collection<Saml2X509Credential> signingX509Credentials;

    private RelyingPartyRegistration(String registrationId, String entityId, String assertionConsumerServiceLocation, Saml2MessageBinding assertionConsumerServiceBinding, String singleLogoutServiceLocation, String singleLogoutServiceResponseLocation, Saml2MessageBinding singleLogoutServiceBinding, ProviderDetails providerDetails, Collection<org.springframework.security.saml2.credentials.Saml2X509Credential> credentials, Collection<Saml2X509Credential> decryptionX509Credentials, Collection<Saml2X509Credential> signingX509Credentials) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        Assert.hasText((String)entityId, (String)"entityId cannot be empty");
        Assert.hasText((String)assertionConsumerServiceLocation, (String)"assertionConsumerServiceLocation cannot be empty");
        Assert.notNull((Object)((Object)assertionConsumerServiceBinding), (String)"assertionConsumerServiceBinding cannot be null");
        Assert.isTrue((singleLogoutServiceLocation == null || singleLogoutServiceBinding != null ? 1 : 0) != 0, (String)"singleLogoutServiceBinding cannot be null when singleLogoutServiceLocation is set");
        Assert.notNull((Object)providerDetails, (String)"providerDetails cannot be null");
        Assert.notEmpty(credentials, (String)"credentials cannot be empty");
        for (org.springframework.security.saml2.credentials.Saml2X509Credential saml2X509Credential : credentials) {
            Assert.notNull((Object)saml2X509Credential, (String)"credentials cannot contain null elements");
        }
        Assert.notNull(decryptionX509Credentials, (String)"decryptionX509Credentials cannot be null");
        for (Saml2X509Credential saml2X509Credential : decryptionX509Credentials) {
            Assert.notNull((Object)saml2X509Credential, (String)"decryptionX509Credentials cannot contain null elements");
            Assert.isTrue((boolean)saml2X509Credential.isDecryptionCredential(), (String)"All decryptionX509Credentials must have a usage of DECRYPTION set");
        }
        Assert.notNull(signingX509Credentials, (String)"signingX509Credentials cannot be null");
        for (Saml2X509Credential saml2X509Credential : signingX509Credentials) {
            Assert.notNull((Object)saml2X509Credential, (String)"signingX509Credentials cannot contain null elements");
            Assert.isTrue((boolean)saml2X509Credential.isSigningCredential(), (String)"All signingX509Credentials must have a usage of SIGNING set");
        }
        this.registrationId = registrationId;
        this.entityId = entityId;
        this.assertionConsumerServiceLocation = assertionConsumerServiceLocation;
        this.assertionConsumerServiceBinding = assertionConsumerServiceBinding;
        this.singleLogoutServiceLocation = singleLogoutServiceLocation;
        this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
        this.singleLogoutServiceBinding = singleLogoutServiceBinding;
        this.providerDetails = providerDetails;
        this.credentials = Collections.unmodifiableList(new LinkedList<org.springframework.security.saml2.credentials.Saml2X509Credential>(credentials));
        this.decryptionX509Credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(decryptionX509Credentials));
        this.signingX509Credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(signingX509Credentials));
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getAssertionConsumerServiceLocation() {
        return this.assertionConsumerServiceLocation;
    }

    public Saml2MessageBinding getAssertionConsumerServiceBinding() {
        return this.assertionConsumerServiceBinding;
    }

    public Saml2MessageBinding getSingleLogoutServiceBinding() {
        return this.singleLogoutServiceBinding;
    }

    public String getSingleLogoutServiceLocation() {
        return this.singleLogoutServiceLocation;
    }

    public String getSingleLogoutServiceResponseLocation() {
        return this.singleLogoutServiceResponseLocation;
    }

    public Collection<Saml2X509Credential> getDecryptionX509Credentials() {
        return this.decryptionX509Credentials;
    }

    public Collection<Saml2X509Credential> getSigningX509Credentials() {
        return this.signingX509Credentials;
    }

    public AssertingPartyDetails getAssertingPartyDetails() {
        return this.providerDetails.assertingPartyDetails;
    }

    @Deprecated
    public String getRemoteIdpEntityId() {
        return this.providerDetails.getEntityId();
    }

    @Deprecated
    public String getAssertionConsumerServiceUrlTemplate() {
        return this.assertionConsumerServiceLocation;
    }

    @Deprecated
    public String getIdpWebSsoUrl() {
        return this.getAssertingPartyDetails().getSingleSignOnServiceLocation();
    }

    @Deprecated
    public ProviderDetails getProviderDetails() {
        return this.providerDetails;
    }

    @Deprecated
    public String getLocalEntityIdTemplate() {
        return this.entityId;
    }

    @Deprecated
    public List<org.springframework.security.saml2.credentials.Saml2X509Credential> getCredentials() {
        return this.credentials;
    }

    @Deprecated
    public List<org.springframework.security.saml2.credentials.Saml2X509Credential> getVerificationCredentials() {
        return this.filterCredentials(org.springframework.security.saml2.credentials.Saml2X509Credential::isSignatureVerficationCredential);
    }

    @Deprecated
    public List<org.springframework.security.saml2.credentials.Saml2X509Credential> getSigningCredentials() {
        return this.filterCredentials(org.springframework.security.saml2.credentials.Saml2X509Credential::isSigningCredential);
    }

    @Deprecated
    public List<org.springframework.security.saml2.credentials.Saml2X509Credential> getEncryptionCredentials() {
        return this.filterCredentials(org.springframework.security.saml2.credentials.Saml2X509Credential::isEncryptionCredential);
    }

    @Deprecated
    public List<org.springframework.security.saml2.credentials.Saml2X509Credential> getDecryptionCredentials() {
        return this.filterCredentials(org.springframework.security.saml2.credentials.Saml2X509Credential::isDecryptionCredential);
    }

    private List<org.springframework.security.saml2.credentials.Saml2X509Credential> filterCredentials(Function<org.springframework.security.saml2.credentials.Saml2X509Credential, Boolean> filter) {
        LinkedList<org.springframework.security.saml2.credentials.Saml2X509Credential> result = new LinkedList<org.springframework.security.saml2.credentials.Saml2X509Credential>();
        for (org.springframework.security.saml2.credentials.Saml2X509Credential c : this.credentials) {
            if (!filter.apply(c).booleanValue()) continue;
            result.add(c);
        }
        return result;
    }

    public static Builder withRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return new Builder(registrationId);
    }

    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        Assert.notNull((Object)registration, (String)"registration cannot be null");
        return RelyingPartyRegistration.withRegistrationId(registration.getRegistrationId()).entityId(registration.getEntityId()).signingX509Credentials(c -> c.addAll(registration.getSigningX509Credentials())).decryptionX509Credentials(c -> c.addAll(registration.getDecryptionX509Credentials())).assertionConsumerServiceLocation(registration.getAssertionConsumerServiceLocation()).assertionConsumerServiceBinding(registration.getAssertionConsumerServiceBinding()).singleLogoutServiceLocation(registration.getSingleLogoutServiceLocation()).singleLogoutServiceResponseLocation(registration.getSingleLogoutServiceResponseLocation()).singleLogoutServiceBinding(registration.getSingleLogoutServiceBinding()).assertingPartyDetails(assertingParty -> assertingParty.entityId(registration.getAssertingPartyDetails().getEntityId()).wantAuthnRequestsSigned(registration.getAssertingPartyDetails().getWantAuthnRequestsSigned()).signingAlgorithms(algorithms -> algorithms.addAll(registration.getAssertingPartyDetails().getSigningAlgorithms())).verificationX509Credentials(c -> c.addAll(registration.getAssertingPartyDetails().getVerificationX509Credentials())).encryptionX509Credentials(c -> c.addAll(registration.getAssertingPartyDetails().getEncryptionX509Credentials())).singleSignOnServiceLocation(registration.getAssertingPartyDetails().getSingleSignOnServiceLocation()).singleSignOnServiceBinding(registration.getAssertingPartyDetails().getSingleSignOnServiceBinding()).singleLogoutServiceLocation(registration.getAssertingPartyDetails().getSingleLogoutServiceLocation()).singleLogoutServiceResponseLocation(registration.getAssertingPartyDetails().getSingleLogoutServiceResponseLocation()).singleLogoutServiceBinding(registration.getAssertingPartyDetails().getSingleLogoutServiceBinding()));
    }

    private static Saml2X509Credential fromDeprecated(org.springframework.security.saml2.credentials.Saml2X509Credential credential) {
        PrivateKey privateKey = credential.getPrivateKey();
        X509Certificate certificate = credential.getCertificate();
        LinkedHashSet<Saml2X509Credential.Saml2X509CredentialType> credentialTypes = new LinkedHashSet<Saml2X509Credential.Saml2X509CredentialType>();
        if (credential.isSigningCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.SIGNING);
        }
        if (credential.isSignatureVerficationCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.VERIFICATION);
        }
        if (credential.isEncryptionCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.ENCRYPTION);
        }
        if (credential.isDecryptionCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.DECRYPTION);
        }
        return new Saml2X509Credential(privateKey, certificate, credentialTypes);
    }

    private static org.springframework.security.saml2.credentials.Saml2X509Credential toDeprecated(Saml2X509Credential credential) {
        PrivateKey privateKey = credential.getPrivateKey();
        X509Certificate certificate = credential.getCertificate();
        LinkedHashSet<Saml2X509Credential.Saml2X509CredentialType> credentialTypes = new LinkedHashSet<Saml2X509Credential.Saml2X509CredentialType>();
        if (credential.isSigningCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.SIGNING);
        }
        if (credential.isVerificationCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.VERIFICATION);
        }
        if (credential.isEncryptionCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.ENCRYPTION);
        }
        if (credential.isDecryptionCredential()) {
            credentialTypes.add(Saml2X509Credential.Saml2X509CredentialType.DECRYPTION);
        }
        return new org.springframework.security.saml2.credentials.Saml2X509Credential(privateKey, certificate, credentialTypes);
    }

    public static final class Builder {
        private String registrationId;
        private String entityId = "{baseUrl}/saml2/service-provider-metadata/{registrationId}";
        private Collection<Saml2X509Credential> signingX509Credentials = new LinkedHashSet<Saml2X509Credential>();
        private Collection<Saml2X509Credential> decryptionX509Credentials = new LinkedHashSet<Saml2X509Credential>();
        private String assertionConsumerServiceLocation = "{baseUrl}/login/saml2/sso/{registrationId}";
        private Saml2MessageBinding assertionConsumerServiceBinding = Saml2MessageBinding.POST;
        private String singleLogoutServiceLocation;
        private String singleLogoutServiceResponseLocation;
        private Saml2MessageBinding singleLogoutServiceBinding = Saml2MessageBinding.POST;
        private ProviderDetails.Builder providerDetails = new ProviderDetails.Builder();
        private Collection<org.springframework.security.saml2.credentials.Saml2X509Credential> credentials = new LinkedHashSet<org.springframework.security.saml2.credentials.Saml2X509Credential>();

        private Builder(String registrationId) {
            this.registrationId = registrationId;
        }

        public Builder registrationId(String id) {
            this.registrationId = id;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder signingX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            credentialsConsumer.accept(this.signingX509Credentials);
            return this;
        }

        public Builder decryptionX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
            credentialsConsumer.accept(this.decryptionX509Credentials);
            return this;
        }

        public Builder assertionConsumerServiceLocation(String assertionConsumerServiceLocation) {
            this.assertionConsumerServiceLocation = assertionConsumerServiceLocation;
            return this;
        }

        public Builder assertionConsumerServiceBinding(Saml2MessageBinding assertionConsumerServiceBinding) {
            this.assertionConsumerServiceBinding = assertionConsumerServiceBinding;
            return this;
        }

        public Builder singleLogoutServiceBinding(Saml2MessageBinding singleLogoutServiceBinding) {
            this.singleLogoutServiceBinding = singleLogoutServiceBinding;
            return this;
        }

        public Builder singleLogoutServiceLocation(String singleLogoutServiceLocation) {
            this.singleLogoutServiceLocation = singleLogoutServiceLocation;
            return this;
        }

        public Builder singleLogoutServiceResponseLocation(String singleLogoutServiceResponseLocation) {
            this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
            return this;
        }

        public Builder assertingPartyDetails(Consumer<AssertingPartyDetails.Builder> assertingPartyDetails) {
            assertingPartyDetails.accept(this.providerDetails.assertingPartyDetailsBuilder);
            return this;
        }

        @Deprecated
        public Builder credentials(Consumer<Collection<org.springframework.security.saml2.credentials.Saml2X509Credential>> credentials) {
            credentials.accept(this.credentials);
            return this;
        }

        @Deprecated
        public Builder assertionConsumerServiceUrlTemplate(String assertionConsumerServiceUrlTemplate) {
            this.assertionConsumerServiceLocation = assertionConsumerServiceUrlTemplate;
            return this;
        }

        @Deprecated
        public Builder remoteIdpEntityId(String entityId) {
            this.assertingPartyDetails(idp -> idp.entityId(entityId));
            return this;
        }

        @Deprecated
        public Builder idpWebSsoUrl(String url) {
            this.assertingPartyDetails(config -> config.singleSignOnServiceLocation(url));
            return this;
        }

        @Deprecated
        public Builder localEntityIdTemplate(String template) {
            this.entityId = template;
            return this;
        }

        @Deprecated
        public Builder providerDetails(Consumer<ProviderDetails.Builder> providerDetails) {
            providerDetails.accept(this.providerDetails);
            return this;
        }

        public RelyingPartyRegistration build() {
            for (org.springframework.security.saml2.credentials.Saml2X509Credential saml2X509Credential : this.credentials) {
                Saml2X509Credential mapped = RelyingPartyRegistration.fromDeprecated(saml2X509Credential);
                if (saml2X509Credential.isSigningCredential()) {
                    this.signingX509Credentials(c -> c.add(mapped));
                }
                if (saml2X509Credential.isDecryptionCredential()) {
                    this.decryptionX509Credentials(c -> c.add(mapped));
                }
                if (saml2X509Credential.isSignatureVerficationCredential()) {
                    this.providerDetails.assertingPartyDetailsBuilder.verificationX509Credentials(c -> c.add(mapped));
                }
                if (!saml2X509Credential.isEncryptionCredential()) continue;
                this.providerDetails.assertingPartyDetailsBuilder.encryptionX509Credentials(c -> c.add(mapped));
            }
            for (Saml2X509Credential saml2X509Credential : this.signingX509Credentials) {
                this.credentials.add(RelyingPartyRegistration.toDeprecated(saml2X509Credential));
            }
            for (Saml2X509Credential saml2X509Credential : this.decryptionX509Credentials) {
                this.credentials.add(RelyingPartyRegistration.toDeprecated(saml2X509Credential));
            }
            for (Saml2X509Credential saml2X509Credential : this.providerDetails.assertingPartyDetailsBuilder.verificationX509Credentials) {
                this.credentials.add(RelyingPartyRegistration.toDeprecated(saml2X509Credential));
            }
            for (Saml2X509Credential saml2X509Credential : this.providerDetails.assertingPartyDetailsBuilder.encryptionX509Credentials) {
                this.credentials.add(RelyingPartyRegistration.toDeprecated(saml2X509Credential));
            }
            if (this.singleLogoutServiceResponseLocation == null) {
                this.singleLogoutServiceResponseLocation = this.singleLogoutServiceLocation;
            }
            return new RelyingPartyRegistration(this.registrationId, this.entityId, this.assertionConsumerServiceLocation, this.assertionConsumerServiceBinding, this.singleLogoutServiceLocation, this.singleLogoutServiceResponseLocation, this.singleLogoutServiceBinding, this.providerDetails.build(), this.credentials, this.decryptionX509Credentials, this.signingX509Credentials);
        }
    }

    @Deprecated
    public static final class ProviderDetails {
        private final AssertingPartyDetails assertingPartyDetails;

        private ProviderDetails(AssertingPartyDetails assertingPartyDetails) {
            Assert.notNull((Object)"assertingPartyDetails cannot be null");
            this.assertingPartyDetails = assertingPartyDetails;
        }

        public String getEntityId() {
            return this.assertingPartyDetails.getEntityId();
        }

        public String getWebSsoUrl() {
            return this.assertingPartyDetails.getSingleSignOnServiceLocation();
        }

        public boolean isSignAuthNRequest() {
            return this.assertingPartyDetails.getWantAuthnRequestsSigned();
        }

        public Saml2MessageBinding getBinding() {
            return this.assertingPartyDetails.getSingleSignOnServiceBinding();
        }

        @Deprecated
        public static final class Builder {
            private final AssertingPartyDetails.Builder assertingPartyDetailsBuilder = new AssertingPartyDetails.Builder();

            public Builder entityId(String entityId) {
                this.assertingPartyDetailsBuilder.entityId(entityId);
                return this;
            }

            public Builder webSsoUrl(String url) {
                this.assertingPartyDetailsBuilder.singleSignOnServiceLocation(url);
                return this;
            }

            public Builder signAuthNRequest(boolean signAuthNRequest) {
                this.assertingPartyDetailsBuilder.wantAuthnRequestsSigned(signAuthNRequest);
                return this;
            }

            public Builder binding(Saml2MessageBinding binding) {
                this.assertingPartyDetailsBuilder.singleSignOnServiceBinding(binding);
                return this;
            }

            public ProviderDetails build() {
                return new ProviderDetails(this.assertingPartyDetailsBuilder.build());
            }
        }
    }

    public static final class AssertingPartyDetails {
        private final String entityId;
        private final boolean wantAuthnRequestsSigned;
        private List<String> signingAlgorithms;
        private final Collection<Saml2X509Credential> verificationX509Credentials;
        private final Collection<Saml2X509Credential> encryptionX509Credentials;
        private final String singleSignOnServiceLocation;
        private final Saml2MessageBinding singleSignOnServiceBinding;
        private final String singleLogoutServiceLocation;
        private final String singleLogoutServiceResponseLocation;
        private final Saml2MessageBinding singleLogoutServiceBinding;

        private AssertingPartyDetails(String entityId, boolean wantAuthnRequestsSigned, List<String> signingAlgorithms, Collection<Saml2X509Credential> verificationX509Credentials, Collection<Saml2X509Credential> encryptionX509Credentials, String singleSignOnServiceLocation, Saml2MessageBinding singleSignOnServiceBinding, String singleLogoutServiceLocation, String singleLogoutServiceResponseLocation, Saml2MessageBinding singleLogoutServiceBinding) {
            Assert.hasText((String)entityId, (String)"entityId cannot be null or empty");
            Assert.notEmpty(signingAlgorithms, (String)"signingAlgorithms cannot be empty");
            Assert.notNull(verificationX509Credentials, (String)"verificationX509Credentials cannot be null");
            for (Saml2X509Credential credential : verificationX509Credentials) {
                Assert.notNull((Object)credential, (String)"verificationX509Credentials cannot have null values");
                Assert.isTrue((boolean)credential.isVerificationCredential(), (String)"All verificationX509Credentials must have a usage of VERIFICATION set");
            }
            Assert.notNull(encryptionX509Credentials, (String)"encryptionX509Credentials cannot be null");
            for (Saml2X509Credential credential : encryptionX509Credentials) {
                Assert.notNull((Object)credential, (String)"encryptionX509Credentials cannot have null values");
                Assert.isTrue((boolean)credential.isEncryptionCredential(), (String)"All encryptionX509Credentials must have a usage of ENCRYPTION set");
            }
            Assert.notNull((Object)singleSignOnServiceLocation, (String)"singleSignOnServiceLocation cannot be null");
            Assert.notNull((Object)((Object)singleSignOnServiceBinding), (String)"singleSignOnServiceBinding cannot be null");
            this.entityId = entityId;
            this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
            this.signingAlgorithms = signingAlgorithms;
            this.verificationX509Credentials = verificationX509Credentials;
            this.encryptionX509Credentials = encryptionX509Credentials;
            this.singleSignOnServiceLocation = singleSignOnServiceLocation;
            this.singleSignOnServiceBinding = singleSignOnServiceBinding;
            this.singleLogoutServiceLocation = singleLogoutServiceLocation;
            this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
            this.singleLogoutServiceBinding = singleLogoutServiceBinding;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public boolean getWantAuthnRequestsSigned() {
            return this.wantAuthnRequestsSigned;
        }

        public List<String> getSigningAlgorithms() {
            return this.signingAlgorithms;
        }

        public Collection<Saml2X509Credential> getVerificationX509Credentials() {
            return this.verificationX509Credentials;
        }

        public Collection<Saml2X509Credential> getEncryptionX509Credentials() {
            return this.encryptionX509Credentials;
        }

        public String getSingleSignOnServiceLocation() {
            return this.singleSignOnServiceLocation;
        }

        public Saml2MessageBinding getSingleSignOnServiceBinding() {
            return this.singleSignOnServiceBinding;
        }

        public String getSingleLogoutServiceLocation() {
            return this.singleLogoutServiceLocation;
        }

        public String getSingleLogoutServiceResponseLocation() {
            return this.singleLogoutServiceResponseLocation;
        }

        public Saml2MessageBinding getSingleLogoutServiceBinding() {
            return this.singleLogoutServiceBinding;
        }

        public static final class Builder {
            private String entityId;
            private boolean wantAuthnRequestsSigned = true;
            private List<String> signingAlgorithms = new ArrayList<String>();
            private Collection<Saml2X509Credential> verificationX509Credentials = new LinkedHashSet<Saml2X509Credential>();
            private Collection<Saml2X509Credential> encryptionX509Credentials = new LinkedHashSet<Saml2X509Credential>();
            private String singleSignOnServiceLocation;
            private Saml2MessageBinding singleSignOnServiceBinding = Saml2MessageBinding.REDIRECT;
            private String singleLogoutServiceLocation;
            private String singleLogoutServiceResponseLocation;
            private Saml2MessageBinding singleLogoutServiceBinding = Saml2MessageBinding.REDIRECT;

            public Builder entityId(String entityId) {
                this.entityId = entityId;
                return this;
            }

            public Builder wantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
                this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
                return this;
            }

            public Builder signingAlgorithms(Consumer<List<String>> signingMethodAlgorithmsConsumer) {
                signingMethodAlgorithmsConsumer.accept(this.signingAlgorithms);
                return this;
            }

            public Builder verificationX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
                credentialsConsumer.accept(this.verificationX509Credentials);
                return this;
            }

            public Builder encryptionX509Credentials(Consumer<Collection<Saml2X509Credential>> credentialsConsumer) {
                credentialsConsumer.accept(this.encryptionX509Credentials);
                return this;
            }

            public Builder singleSignOnServiceLocation(String singleSignOnServiceLocation) {
                this.singleSignOnServiceLocation = singleSignOnServiceLocation;
                return this;
            }

            public Builder singleSignOnServiceBinding(Saml2MessageBinding singleSignOnServiceBinding) {
                this.singleSignOnServiceBinding = singleSignOnServiceBinding;
                return this;
            }

            public Builder singleLogoutServiceLocation(String singleLogoutServiceLocation) {
                this.singleLogoutServiceLocation = singleLogoutServiceLocation;
                return this;
            }

            public Builder singleLogoutServiceResponseLocation(String singleLogoutServiceResponseLocation) {
                this.singleLogoutServiceResponseLocation = singleLogoutServiceResponseLocation;
                return this;
            }

            public Builder singleLogoutServiceBinding(Saml2MessageBinding singleLogoutServiceBinding) {
                this.singleLogoutServiceBinding = singleLogoutServiceBinding;
                return this;
            }

            public AssertingPartyDetails build() {
                List<String> signingAlgorithms = this.signingAlgorithms.isEmpty() ? Collections.singletonList("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") : Collections.unmodifiableList(this.signingAlgorithms);
                return new AssertingPartyDetails(this.entityId, this.wantAuthnRequestsSigned, signingAlgorithms, this.verificationX509Credentials, this.encryptionX509Credentials, this.singleSignOnServiceLocation, this.singleSignOnServiceBinding, this.singleLogoutServiceLocation, this.singleLogoutServiceResponseLocation, this.singleLogoutServiceBinding);
            }
        }
    }
}

