/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidatorParameters;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutValidatorResult;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.CompositeLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class Saml2LogoutRequestFilter
extends OncePerRequestFilter {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Saml2LogoutRequestValidator logoutRequestValidator;
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private final Saml2LogoutResponseResolver logoutResponseResolver;
    private final LogoutHandler handler;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private RequestMatcher logoutRequestMatcher = new AntPathRequestMatcher("/logout/saml2/slo");

    public Saml2LogoutRequestFilter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver, Saml2LogoutRequestValidator logoutRequestValidator, Saml2LogoutResponseResolver logoutResponseResolver, LogoutHandler ... handlers) {
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.logoutRequestValidator = logoutRequestValidator;
        this.logoutResponseResolver = logoutResponseResolver;
        this.handler = new CompositeLogoutHandler(handlers);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!this.logoutRequestMatcher.matches(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getParameter("SAMLRequest") == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, this.getRegistrationId(authentication));
        if (registration == null) {
            this.logger.trace((Object)"Did not process logout request since failed to find associated RelyingPartyRegistration");
            response.sendError(400);
            return;
        }
        if (!this.isCorrectBinding(request, registration)) {
            this.logger.trace((Object)"Did not process logout request since used incorrect binding");
            response.sendError(401);
            return;
        }
        String serialized = request.getParameter("SAMLRequest");
        Saml2LogoutRequest logoutRequest = Saml2LogoutRequest.withRelyingPartyRegistration(registration).samlRequest(serialized).relayState(request.getParameter("RelayState")).binding(registration.getSingleLogoutServiceBinding()).location(registration.getSingleLogoutServiceLocation()).parameters(params -> params.put("SigAlg", request.getParameter("SigAlg"))).parameters(params -> params.put("Signature", request.getParameter("Signature"))).build();
        Saml2LogoutRequestValidatorParameters parameters = new Saml2LogoutRequestValidatorParameters(logoutRequest, registration, authentication);
        Saml2LogoutValidatorResult result = this.logoutRequestValidator.validate(parameters);
        if (result.hasErrors()) {
            response.sendError(401, result.getErrors().iterator().next().toString());
            this.logger.debug((Object)LogMessage.format((String)"Failed to validate LogoutRequest: %s", result.getErrors()));
            return;
        }
        this.handler.logout(request, response, authentication);
        Saml2LogoutResponse logoutResponse = this.logoutResponseResolver.resolve(request, authentication);
        if (logoutResponse == null) {
            this.logger.trace((Object)"Returning 401 since no logout response generated");
            response.setStatus(401);
            return;
        }
        if (logoutResponse.getBinding() == Saml2MessageBinding.REDIRECT) {
            this.doRedirect(request, response, logoutResponse);
        } else {
            this.doPost(response, logoutResponse);
        }
    }

    public void setLogoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
        this.logoutRequestMatcher = logoutRequestMatcher;
    }

    private String getRegistrationId(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof Saml2AuthenticatedPrincipal) {
            return ((Saml2AuthenticatedPrincipal)principal).getRelyingPartyRegistrationId();
        }
        return null;
    }

    private boolean isCorrectBinding(HttpServletRequest request, RelyingPartyRegistration registration) {
        Saml2MessageBinding requiredBinding = registration.getSingleLogoutServiceBinding();
        if (requiredBinding == Saml2MessageBinding.POST) {
            return "POST".equals(request.getMethod());
        }
        return "GET".equals(request.getMethod());
    }

    private void doRedirect(HttpServletRequest request, HttpServletResponse response, Saml2LogoutResponse logoutResponse) throws IOException {
        String location = logoutResponse.getResponseLocation();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)location);
        this.addParameter("SAMLResponse", logoutResponse::getParameter, uriBuilder);
        this.addParameter("RelayState", logoutResponse::getParameter, uriBuilder);
        this.addParameter("SigAlg", logoutResponse::getParameter, uriBuilder);
        this.addParameter("Signature", logoutResponse::getParameter, uriBuilder);
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.build(true).toUriString());
    }

    private void addParameter(String name, Function<String, String> parameters, UriComponentsBuilder builder) {
        Assert.hasText((String)name, (String)"name cannot be empty or null");
        if (StringUtils.hasText((String)parameters.apply(name))) {
            builder.queryParam(UriUtils.encode((String)name, (Charset)StandardCharsets.ISO_8859_1), new Object[]{UriUtils.encode((String)parameters.apply(name), (Charset)StandardCharsets.ISO_8859_1)});
        }
    }

    private void doPost(HttpServletResponse response, Saml2LogoutResponse logoutResponse) throws IOException {
        String location = logoutResponse.getResponseLocation();
        String saml = logoutResponse.getSamlResponse();
        String relayState = logoutResponse.getRelayState();
        String html = this.createSamlPostRequestFormData(location, saml, relayState);
        response.setContentType("text/html");
        response.getWriter().write(html);
    }

    private String createSamlPostRequestFormData(String location, String saml, String relayState) {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>\n").append("    <head>\n");
        html.append("        <meta charset=\"utf-8\" />\n");
        html.append("    </head>\n");
        html.append("    <body onload=\"document.forms[0].submit()\">\n");
        html.append("        <noscript>\n");
        html.append("            <p>\n");
        html.append("                <strong>Note:</strong> Since your browser does not support JavaScript,\n");
        html.append("                you must press the Continue button once to proceed.\n");
        html.append("            </p>\n");
        html.append("        </noscript>\n");
        html.append("        \n");
        html.append("        <form action=\"");
        html.append(location);
        html.append("\" method=\"post\">\n");
        html.append("            <div>\n");
        html.append("                <input type=\"hidden\" name=\"SAMLResponse\" value=\"");
        html.append(HtmlUtils.htmlEscape((String)saml));
        html.append("\"/>\n");
        if (StringUtils.hasText((String)relayState)) {
            html.append("                <input type=\"hidden\" name=\"RelayState\" value=\"");
            html.append(HtmlUtils.htmlEscape((String)relayState));
            html.append("\"/>\n");
        }
        html.append("            </div>\n");
        html.append("            <noscript>\n");
        html.append("                <div>\n");
        html.append("                    <input type=\"submit\" value=\"Continue\"/>\n");
        html.append("                </div>\n");
        html.append("            </noscript>\n");
        html.append("        </form>\n");
        html.append("        \n");
        html.append("    </body>\n");
        html.append("</html>");
        return html.toString();
    }
}

