/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public final class Saml2LogoutRequest
implements Serializable {
    private final String location;
    private final Saml2MessageBinding binding;
    private final Map<String, String> parameters;
    private final String id;
    private final String relyingPartyRegistrationId;

    private Saml2LogoutRequest(String location, Saml2MessageBinding binding, Map<String, String> parameters, String id, String relyingPartyRegistrationId) {
        this.location = location;
        this.binding = binding;
        this.parameters = Collections.unmodifiableMap(new HashMap<String, String>(parameters));
        this.id = id;
        this.relyingPartyRegistrationId = relyingPartyRegistrationId;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public Saml2MessageBinding getBinding() {
        return this.binding;
    }

    public String getSamlRequest() {
        return this.parameters.get("SAMLRequest");
    }

    public String getRelayState() {
        return this.parameters.get("RelayState");
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getRelyingPartyRegistrationId() {
        return this.relyingPartyRegistrationId;
    }

    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        return new Builder(registration);
    }

    public static final class Builder {
        private final RelyingPartyRegistration registration;
        private String location;
        private Saml2MessageBinding binding;
        private Map<String, String> parameters = new HashMap<String, String>();
        private String id;

        private Builder(RelyingPartyRegistration registration) {
            this.registration = registration;
            this.location = registration.getAssertingPartyDetails().getSingleLogoutServiceLocation();
            this.binding = registration.getAssertingPartyDetails().getSingleLogoutServiceBinding();
        }

        public Builder samlRequest(String samlRequest) {
            this.parameters.put("SAMLRequest", samlRequest);
            return this;
        }

        public Builder binding(Saml2MessageBinding binding) {
            this.binding = binding;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder relayState(String relayState) {
            this.parameters.put("RelayState", relayState);
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder parameters(Consumer<Map<String, String>> parametersConsumer) {
            parametersConsumer.accept(this.parameters);
            return this;
        }

        public Saml2LogoutRequest build() {
            return new Saml2LogoutRequest(this.location, this.binding, this.parameters, this.id, this.registration.getRegistrationId());
        }
    }
}

