/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlSigningUtils;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2Utils;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OpenSamlAuthenticationRequestFactory
implements Saml2AuthenticationRequestFactory {
    private AuthnRequestBuilder authnRequestBuilder;
    private IssuerBuilder issuerBuilder;
    private Clock clock = Clock.systemUTC();
    private Converter<Saml2AuthenticationRequestContext, Saml2MessageBinding> protocolBindingResolver = context -> {
        if (context == null) {
            return Saml2MessageBinding.POST;
        }
        return context.getRelyingPartyRegistration().getAssertionConsumerServiceBinding();
    };
    private Converter<Saml2AuthenticationRequestContext, AuthnRequest> authenticationRequestContextConverter = this::createAuthnRequest;

    public OpenSamlAuthenticationRequestFactory() {
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.authnRequestBuilder = (AuthnRequestBuilder)registry.getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        this.issuerBuilder = (IssuerBuilder)registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
    }

    @Override
    @Deprecated
    public String createAuthenticationRequest(Saml2AuthenticationRequest request) {
        Saml2MessageBinding binding = (Saml2MessageBinding)((Object)this.protocolBindingResolver.convert(null));
        RelyingPartyRegistration registration = RelyingPartyRegistration.withRegistrationId("noId").assertionConsumerServiceBinding(binding).assertionConsumerServiceLocation(request.getAssertionConsumerServiceUrl()).entityId(request.getIssuer()).remoteIdpEntityId("noIssuer").idpWebSsoUrl("noUrl").credentials(credentials -> credentials.addAll(request.getCredentials())).build();
        Saml2AuthenticationRequestContext context = Saml2AuthenticationRequestContext.builder().relyingPartyRegistration(registration).issuer(request.getIssuer()).assertionConsumerServiceUrl(request.getAssertionConsumerServiceUrl()).build();
        AuthnRequest authnRequest = (AuthnRequest)this.authenticationRequestContextConverter.convert((Object)context);
        return OpenSamlSigningUtils.serialize((XMLObject)OpenSamlSigningUtils.sign(authnRequest, registration));
    }

    @Override
    public Saml2PostAuthenticationRequest createPostAuthenticationRequest(Saml2AuthenticationRequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)this.authenticationRequestContextConverter.convert((Object)context);
        RelyingPartyRegistration registration = context.getRelyingPartyRegistration();
        if (registration.getAssertingPartyDetails().getWantAuthnRequestsSigned()) {
            OpenSamlSigningUtils.sign(authnRequest, registration);
        }
        String xml = OpenSamlSigningUtils.serialize((XMLObject)authnRequest);
        return ((Saml2PostAuthenticationRequest.Builder)Saml2PostAuthenticationRequest.withAuthenticationRequestContext(context).samlRequest(Saml2Utils.samlEncode(xml.getBytes(StandardCharsets.UTF_8)))).build();
    }

    @Override
    public Saml2RedirectAuthenticationRequest createRedirectAuthenticationRequest(Saml2AuthenticationRequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)this.authenticationRequestContextConverter.convert((Object)context);
        RelyingPartyRegistration registration = context.getRelyingPartyRegistration();
        String xml = OpenSamlSigningUtils.serialize((XMLObject)authnRequest);
        Saml2RedirectAuthenticationRequest.Builder result = Saml2RedirectAuthenticationRequest.withAuthenticationRequestContext(context);
        String deflatedAndEncoded = Saml2Utils.samlEncode(Saml2Utils.samlDeflate(xml));
        ((Saml2RedirectAuthenticationRequest.Builder)result.samlRequest(deflatedAndEncoded)).relayState(context.getRelayState());
        if (registration.getAssertingPartyDetails().getWantAuthnRequestsSigned()) {
            OpenSamlSigningUtils.QueryParametersPartial partial = OpenSamlSigningUtils.sign(registration).param("SAMLRequest", deflatedAndEncoded);
            if (StringUtils.hasText((String)context.getRelayState())) {
                partial.param("RelayState", context.getRelayState());
            }
            Map<String, String> parameters = partial.parameters();
            return result.sigAlg(parameters.get("SigAlg")).signature(parameters.get("Signature")).build();
        }
        return result.build();
    }

    private AuthnRequest createAuthnRequest(Saml2AuthenticationRequestContext context) {
        String issuer = context.getIssuer();
        String destination = context.getDestination();
        String assertionConsumerServiceUrl = context.getAssertionConsumerServiceUrl();
        Saml2MessageBinding protocolBinding = (Saml2MessageBinding)((Object)this.protocolBindingResolver.convert((Object)context));
        AuthnRequest auth = this.authnRequestBuilder.buildObject();
        if (auth.getID() == null) {
            auth.setID("ARQ" + UUID.randomUUID().toString().substring(1));
        }
        if (auth.getIssueInstant() == null) {
            auth.setIssueInstant(new DateTime(this.clock.millis()));
        }
        if (auth.isForceAuthn() == null) {
            auth.setForceAuthn(Boolean.FALSE);
        }
        if (auth.isPassive() == null) {
            auth.setIsPassive(Boolean.FALSE);
        }
        if (auth.getProtocolBinding() == null) {
            auth.setProtocolBinding(protocolBinding.getUrn());
        }
        Issuer iss = this.issuerBuilder.buildObject();
        iss.setValue(issuer);
        auth.setIssuer(iss);
        auth.setDestination(destination);
        auth.setAssertionConsumerServiceURL(assertionConsumerServiceUrl);
        return auth;
    }

    public void setAuthenticationRequestContextConverter(Converter<Saml2AuthenticationRequestContext, AuthnRequest> authenticationRequestContextConverter) {
        Assert.notNull(authenticationRequestContextConverter, (String)"authenticationRequestContextConverter cannot be null");
        this.authenticationRequestContextConverter = authenticationRequestContextConverter;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    @Deprecated
    public void setProtocolBinding(String protocolBinding) {
        Saml2MessageBinding binding = Saml2MessageBinding.from(protocolBinding);
        Assert.notNull((Object)((Object)binding), (String)("Invalid protocol binding: " + protocolBinding));
        this.protocolBindingResolver = context -> binding;
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

