/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.registration.OpenSamlAssertingPartyMetadataConverter;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

public final class RelyingPartyRegistrations {
    private static final OpenSamlAssertingPartyMetadataConverter assertingPartyMetadataConverter = new OpenSamlAssertingPartyMetadataConverter();
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader();

    private RelyingPartyRegistrations() {
    }

    public static RelyingPartyRegistration.Builder fromMetadataLocation(String metadataLocation) {
        RelyingPartyRegistration.Builder builder;
        block9: {
            InputStream source = resourceLoader.getResource(metadataLocation).getInputStream();
            try {
                builder = assertingPartyMetadataConverter.convert(source);
                if (source == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    if (ex.getCause() instanceof Saml2Exception) {
                        throw (Saml2Exception)ex.getCause();
                    }
                    throw new Saml2Exception(ex);
                }
            }
            source.close();
        }
        return builder;
    }
}

