/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.util.Collections;
import java.util.List;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;

public class Saml2AuthenticationToken
extends AbstractAuthenticationToken {
    private final RelyingPartyRegistration relyingPartyRegistration;
    private final String saml2Response;

    public Saml2AuthenticationToken(RelyingPartyRegistration relyingPartyRegistration, String saml2Response) {
        super(Collections.emptyList());
        Assert.notNull((Object)relyingPartyRegistration, (String)"relyingPartyRegistration cannot be null");
        Assert.notNull((Object)saml2Response, (String)"saml2Response cannot be null");
        this.relyingPartyRegistration = relyingPartyRegistration;
        this.saml2Response = saml2Response;
    }

    @Deprecated
    public Saml2AuthenticationToken(String saml2Response, String recipientUri, String idpEntityId, String localSpEntityId, List<Saml2X509Credential> credentials) {
        super(null);
        this.relyingPartyRegistration = RelyingPartyRegistration.withRegistrationId(idpEntityId).entityId(localSpEntityId).assertionConsumerServiceLocation(recipientUri).credentials(c -> c.addAll(credentials)).assertingPartyDetails(assertingParty -> assertingParty.entityId(idpEntityId).singleSignOnServiceLocation(idpEntityId)).build();
        this.saml2Response = saml2Response;
    }

    public Object getCredentials() {
        return this.getSaml2Response();
    }

    public Object getPrincipal() {
        return null;
    }

    public RelyingPartyRegistration getRelyingPartyRegistration() {
        return this.relyingPartyRegistration;
    }

    public String getSaml2Response() {
        return this.saml2Response;
    }

    @Deprecated
    public String getRecipientUri() {
        return this.relyingPartyRegistration.getAssertionConsumerServiceLocation();
    }

    @Deprecated
    public String getLocalSpEntityId() {
        return this.relyingPartyRegistration.getEntityId();
    }

    @Deprecated
    public List<Saml2X509Credential> getX509Credentials() {
        return this.relyingPartyRegistration.getCredentials();
    }

    public boolean isAuthenticated() {
        return false;
    }

    public void setAuthenticated(boolean authenticated) {
        throw new IllegalArgumentException();
    }

    @Deprecated
    public String getIdpEntityId() {
        return this.relyingPartyRegistration.getAssertingPartyDetails().getEntityId();
    }
}

