/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import java.util.HashMap;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class DefaultRelyingPartyRegistrationResolver
implements Converter<HttpServletRequest, RelyingPartyRegistration> {
    private static final char PATH_DELIMITER = '/';
    private final RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private final Converter<HttpServletRequest, String> registrationIdResolver = new RegistrationIdResolver();

    public DefaultRelyingPartyRegistrationResolver(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        Assert.notNull((Object)relyingPartyRegistrationRepository, (String)"relyingPartyRegistrationRepository cannot be null");
        this.relyingPartyRegistrationRepository = relyingPartyRegistrationRepository;
    }

    public RelyingPartyRegistration convert(HttpServletRequest request) {
        String registrationId = (String)this.registrationIdResolver.convert((Object)request);
        if (registrationId == null) {
            return null;
        }
        RelyingPartyRegistration relyingPartyRegistration = this.relyingPartyRegistrationRepository.findByRegistrationId(registrationId);
        if (relyingPartyRegistration == null) {
            return null;
        }
        String applicationUri = DefaultRelyingPartyRegistrationResolver.getApplicationUri(request);
        Function<String, String> templateResolver = this.templateResolver(applicationUri, relyingPartyRegistration);
        String relyingPartyEntityId = templateResolver.apply(relyingPartyRegistration.getEntityId());
        String assertionConsumerServiceLocation = templateResolver.apply(relyingPartyRegistration.getAssertionConsumerServiceLocation());
        return RelyingPartyRegistration.withRelyingPartyRegistration(relyingPartyRegistration).entityId(relyingPartyEntityId).assertionConsumerServiceLocation(assertionConsumerServiceLocation).build();
    }

    private Function<String, String> templateResolver(String applicationUri, RelyingPartyRegistration relyingParty) {
        return template -> DefaultRelyingPartyRegistrationResolver.resolveUrlTemplate(template, applicationUri, relyingParty);
    }

    private static String resolveUrlTemplate(String template, String baseUrl, RelyingPartyRegistration relyingParty) {
        String entityId = relyingParty.getAssertingPartyDetails().getEntityId();
        String registrationId = relyingParty.getRegistrationId();
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)baseUrl).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        String path = uriComponents.getPath();
        if (StringUtils.hasLength((String)path) && path.charAt(0) != '/') {
            path = '/' + path;
        }
        uriVariables.put("basePath", path != null ? path : "");
        uriVariables.put("baseUrl", uriComponents.toUriString());
        uriVariables.put("entityId", StringUtils.hasText((String)entityId) ? entityId : "");
        uriVariables.put("registrationId", StringUtils.hasText((String)registrationId) ? registrationId : "");
        return UriComponentsBuilder.fromUriString((String)template).buildAndExpand(uriVariables).toUriString();
    }

    private static String getApplicationUri(HttpServletRequest request) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        return uriComponents.toUriString();
    }

    private static class RegistrationIdResolver
    implements Converter<HttpServletRequest, String> {
        private final RequestMatcher requestMatcher = new AntPathRequestMatcher("/**/{registrationId}");

        private RegistrationIdResolver() {
        }

        public String convert(HttpServletRequest request) {
            RequestMatcher.MatchResult result = this.requestMatcher.matcher(request);
            return (String)result.getVariables().get("registrationId");
        }
    }
}

