/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class OpenSamlAssertingPartyMetadataConverter {
    private final XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
    private final ParserPool parserPool = this.registry.getParserPool();

    OpenSamlAssertingPartyMetadataConverter() {
    }

    RelyingPartyRegistration.Builder convert(InputStream inputStream) {
        EntityDescriptor descriptor = this.entityDescriptor(inputStream);
        IDPSSODescriptor idpssoDescriptor = descriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpssoDescriptor == null) {
            throw new Saml2Exception("Metadata response is missing the necessary IDPSSODescriptor element");
        }
        ArrayList<Saml2X509Credential> verification = new ArrayList<Saml2X509Credential>();
        ArrayList<Saml2X509Credential> encryption = new ArrayList<Saml2X509Credential>();
        for (KeyDescriptor keyDescriptor : idpssoDescriptor.getKeyDescriptors()) {
            List<X509Certificate> certificates;
            if (keyDescriptor.getUse().equals((Object)UsageType.SIGNING)) {
                certificates = this.certificates(keyDescriptor);
                for (X509Certificate certificate : certificates) {
                    verification.add(Saml2X509Credential.verification(certificate));
                }
            }
            if (keyDescriptor.getUse().equals((Object)UsageType.ENCRYPTION)) {
                certificates = this.certificates(keyDescriptor);
                for (X509Certificate certificate : certificates) {
                    encryption.add(Saml2X509Credential.encryption(certificate));
                }
            }
            if (!keyDescriptor.getUse().equals((Object)UsageType.UNSPECIFIED)) continue;
            certificates = this.certificates(keyDescriptor);
            for (X509Certificate certificate : certificates) {
                verification.add(Saml2X509Credential.verification(certificate));
                encryption.add(Saml2X509Credential.encryption(certificate));
            }
        }
        if (verification.isEmpty()) {
            throw new Saml2Exception("Metadata response is missing verification certificates, necessary for verifying SAML assertions");
        }
        RelyingPartyRegistration.Builder builder = RelyingPartyRegistration.withRegistrationId(descriptor.getEntityID()).assertingPartyDetails(party -> party.entityId(descriptor.getEntityID()).wantAuthnRequestsSigned(Boolean.TRUE.equals(idpssoDescriptor.getWantAuthnRequestsSigned())).verificationX509Credentials(c -> c.addAll(verification)).encryptionX509Credentials(c -> c.addAll(encryption)));
        List<SigningMethod> signingMethods = this.signingMethods(idpssoDescriptor);
        for (SigningMethod method : signingMethods) {
            builder.assertingPartyDetails(party -> party.signingAlgorithms(algorithms -> algorithms.add(method.getAlgorithm())));
        }
        for (SingleSignOnService singleSignOnService : idpssoDescriptor.getSingleSignOnServices()) {
            Saml2MessageBinding binding;
            if (singleSignOnService.getBinding().equals(Saml2MessageBinding.POST.getUrn())) {
                binding = Saml2MessageBinding.POST;
            } else {
                if (!singleSignOnService.getBinding().equals(Saml2MessageBinding.REDIRECT.getUrn())) continue;
                binding = Saml2MessageBinding.REDIRECT;
            }
            builder.assertingPartyDetails(party -> party.singleSignOnServiceLocation(singleSignOnService.getLocation()).singleSignOnServiceBinding(binding));
            return builder;
        }
        throw new Saml2Exception("Metadata response is missing a SingleSignOnService, necessary for sending AuthnRequests");
    }

    private List<X509Certificate> certificates(KeyDescriptor keyDescriptor) {
        try {
            return KeyInfoSupport.getCertificates((KeyInfo)keyDescriptor.getKeyInfo());
        }
        catch (CertificateException ex) {
            throw new Saml2Exception(ex);
        }
    }

    private List<SigningMethod> signingMethods(IDPSSODescriptor idpssoDescriptor) {
        Extensions extensions = idpssoDescriptor.getExtensions();
        List<SigningMethod> result = this.signingMethods(extensions);
        if (!result.isEmpty()) {
            return result;
        }
        EntityDescriptor descriptor = (EntityDescriptor)idpssoDescriptor.getParent();
        extensions = descriptor.getExtensions();
        return this.signingMethods(extensions);
    }

    private EntityDescriptor entityDescriptor(InputStream inputStream) {
        Document document = this.document(inputStream);
        Element element = document.getDocumentElement();
        Unmarshaller unmarshaller = this.registry.getUnmarshallerFactory().getUnmarshaller(element);
        if (unmarshaller == null) {
            throw new Saml2Exception("Unsupported element of type " + element.getTagName());
        }
        try {
            XMLObject object = unmarshaller.unmarshall(element);
            if (object instanceof EntitiesDescriptor) {
                return (EntityDescriptor)((EntitiesDescriptor)object).getEntityDescriptors().get(0);
            }
            if (object instanceof EntityDescriptor) {
                return (EntityDescriptor)object;
            }
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
        throw new Saml2Exception("Unsupported element of type " + element.getTagName());
    }

    private Document document(InputStream inputStream) {
        try {
            return this.parserPool.parse(inputStream);
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private <T> List<T> signingMethods(Extensions extensions) {
        if (extensions != null) {
            return extensions.getUnknownXMLObjects(SigningMethod.DEFAULT_ELEMENT_NAME);
        }
        return new ArrayList();
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

