/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.authentication.Saml2Error;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2ServletUtils;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2Utils;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Saml2WebSsoAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String DEFAULT_FILTER_PROCESSES_URI = "/login/saml2/sso/{registrationId}";
    private final RequestMatcher matcher;
    private final RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        this(relyingPartyRegistrationRepository, DEFAULT_FILTER_PROCESSES_URI);
    }

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository, String filterProcessesUrl) {
        super(filterProcessesUrl);
        Assert.notNull((Object)relyingPartyRegistrationRepository, (String)"relyingPartyRegistrationRepository cannot be null");
        Assert.hasText((String)filterProcessesUrl, (String)"filterProcessesUrl must contain a URL pattern");
        Assert.isTrue((boolean)filterProcessesUrl.contains("{registrationId}"), (String)"filterProcessesUrl must contain a {registrationId} match variable");
        this.matcher = new AntPathRequestMatcher(filterProcessesUrl);
        this.setRequiresAuthenticationRequestMatcher(this.matcher);
        this.relyingPartyRegistrationRepository = relyingPartyRegistrationRepository;
        this.setAllowSessionCreation(true);
        this.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return super.requiresAuthentication(request, response) && StringUtils.hasText((String)request.getParameter("SAMLResponse"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String saml2Response = request.getParameter("SAMLResponse");
        byte[] b = Saml2Utils.samlDecode(saml2Response);
        String responseXml = this.inflateIfRequired(request, b);
        String registrationId = (String)this.matcher.matcher(request).getVariables().get("registrationId");
        RelyingPartyRegistration rp = this.relyingPartyRegistrationRepository.findByRegistrationId(registrationId);
        if (rp == null) {
            Saml2Error saml2Error = new Saml2Error("relying_party_registration_not_found", "Relying Party Registration not found with ID: " + registrationId);
            throw new Saml2AuthenticationException(saml2Error);
        }
        String applicationUri = Saml2ServletUtils.getApplicationUri(request);
        String localSpEntityId = Saml2ServletUtils.resolveUrlTemplate(rp.getLocalEntityIdTemplate(), applicationUri, rp);
        Saml2AuthenticationToken authentication = new Saml2AuthenticationToken(responseXml, request.getRequestURL().toString(), rp.getProviderDetails().getEntityId(), localSpEntityId, rp.getCredentials());
        return this.getAuthenticationManager().authenticate((Authentication)authentication);
    }

    private String inflateIfRequired(HttpServletRequest request, byte[] b) {
        if (HttpMethod.GET.matches(request.getMethod())) {
            return Saml2Utils.samlInflate(b);
        }
        return new String(b, StandardCharsets.UTF_8);
    }
}

