/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class OpenSamlImplementation {
    private static OpenSamlImplementation instance = new OpenSamlImplementation();
    private final BasicParserPool parserPool = new BasicParserPool();
    private final EncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver()));

    private OpenSamlImplementation() {
        this.bootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootstrap() {
        this.parserPool.setMaxPoolSize(50);
        this.parserPool.setCoalescing(true);
        this.parserPool.setExpandEntityReferences(false);
        this.parserPool.setIgnoreComments(true);
        this.parserPool.setIgnoreElementContentWhitespace(true);
        this.parserPool.setNamespaceAware(true);
        this.parserPool.setSchema(null);
        this.parserPool.setDTDValidating(false);
        this.parserPool.setXincludeAware(false);
        HashMap builderAttributes = new HashMap();
        this.parserPool.setBuilderAttributes(builderAttributes);
        HashMap<String, Boolean> parserBuilderFeatures = new HashMap<String, Boolean>();
        parserBuilderFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        parserBuilderFeatures.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        parserBuilderFeatures.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        parserBuilderFeatures.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        parserBuilderFeatures.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        parserBuilderFeatures.put("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        this.parserPool.setBuilderFeatures(parserBuilderFeatures);
        try {
            this.parserPool.initialize();
        }
        catch (ComponentInitializationException x) {
            throw new Saml2Exception("Unable to initialize OpenSaml v3 ParserPool", x);
        }
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            throw new Saml2Exception("Unable to initialize OpenSaml v3", e);
        }
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            if (registry == null) {
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var4_6] (shouldn't be in output)
            registry.setParserPool((ParserPool)this.parserPool);
            return;
        }
    }

    static OpenSamlImplementation getInstance() {
        return instance;
    }

    EncryptedKeyResolver getEncryptedKeyResolver() {
        return this.encryptedKeyResolver;
    }

    <T> T buildSAMLObject(Class<T> clazz) {
        try {
            QName defaultElementName = (QName)clazz.getDeclaredField("DEFAULT_ELEMENT_NAME").get(null);
            return (T)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(defaultElementName).buildObject(defaultElementName);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new Saml2Exception("Could not create SAML object", e);
        }
    }

    XMLObject resolve(String xml) {
        return this.resolve(xml.getBytes(StandardCharsets.UTF_8));
    }

    String toXml(XMLObject object, List<Saml2X509Credential> signingCredentials, String localSpEntityId) {
        if (object instanceof SignableSAMLObject && null != this.hasSigningCredential(signingCredentials)) {
            this.signXmlObject((SignableSAMLObject)object, signingCredentials, localSpEntityId);
        }
        MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        try {
            Element element = marshallerFactory.getMarshaller(object).marshall(object);
            return SerializeSupport.nodeToString((Node)element);
        }
        catch (MarshallingException e) {
            throw new Saml2Exception(e);
        }
    }

    private XMLObject resolve(byte[] xml) {
        XMLObject parsed = this.parse(xml);
        if (parsed != null) {
            return parsed;
        }
        throw new Saml2Exception("Deserialization not supported for given data set");
    }

    private XMLObject parse(byte[] xml) {
        try {
            Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(xml));
            Element element = document.getDocumentElement();
            return this.getUnmarshallerFactory().getUnmarshaller(element).unmarshall(element);
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new Saml2Exception(e);
        }
    }

    private UnmarshallerFactory getUnmarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    private Saml2X509Credential hasSigningCredential(List<Saml2X509Credential> credentials) {
        for (Saml2X509Credential c : credentials) {
            if (!c.isSigningCredential()) continue;
            return c;
        }
        return null;
    }

    private Credential getSigningCredential(List<Saml2X509Credential> signingCredential, String localSpEntityId) {
        Saml2X509Credential credential = this.hasSigningCredential(signingCredential);
        if (credential == null) {
            throw new Saml2Exception("no signing credential configured");
        }
        BasicX509Credential cred = this.getBasicCredential(credential);
        cred.setEntityId(localSpEntityId);
        cred.setUsageType(UsageType.SIGNING);
        return cred;
    }

    private void signXmlObject(SignableSAMLObject object, List<Saml2X509Credential> signingCredentials, String entityId) {
        SignatureSigningParameters parameters = new SignatureSigningParameters();
        Credential credential = this.getSigningCredential(signingCredentials, entityId);
        parameters.setSigningCredential(credential);
        parameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        parameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        parameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            SignatureSupport.signObject((SignableXMLObject)object, (SignatureSigningParameters)parameters);
        }
        catch (MarshallingException | SecurityException | SignatureException e) {
            throw new Saml2Exception(e);
        }
    }

    private BasicX509Credential getBasicCredential(Saml2X509Credential credential) {
        return CredentialSupport.getSimpleCredential((X509Certificate)credential.getCertificate(), (PrivateKey)credential.getPrivateKey());
    }
}

