/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.authorization;

import org.springframework.core.Ordered;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.rsocket.api.PayloadExchange;
import org.springframework.security.rsocket.api.PayloadInterceptor;
import org.springframework.security.rsocket.api.PayloadInterceptorChain;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class AuthorizationPayloadInterceptor
implements PayloadInterceptor,
Ordered {
    private final ReactiveAuthorizationManager<PayloadExchange> authorizationManager;
    private int order;

    public AuthorizationPayloadInterceptor(ReactiveAuthorizationManager<PayloadExchange> authorizationManager) {
        Assert.notNull(authorizationManager, (String)"authorizationManager cannot be null");
        this.authorizationManager = authorizationManager;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Mono<Void> intercept(PayloadExchange exchange, PayloadInterceptorChain chain) {
        return ((Mono)ReactiveSecurityContextHolder.getContext().mapNotNull(SecurityContext::getAuthentication).switchIfEmpty(Mono.error(() -> new AuthenticationCredentialsNotFoundException("An Authentication (possibly AnonymousAuthenticationToken) is required."))).as(authentication -> this.authorizationManager.verify(authentication, (Object)exchange))).then(chain.next(exchange));
    }
}

