/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.core;

import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.ResponderRSocket;
import io.rsocket.util.RSocketProxy;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.security.rsocket.api.PayloadExchangeType;
import org.springframework.security.rsocket.api.PayloadInterceptor;
import org.springframework.security.rsocket.core.ContextPayloadInterceptorChain;
import org.springframework.security.rsocket.core.DefaultPayloadExchange;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class PayloadInterceptorRSocket
extends RSocketProxy
implements ResponderRSocket {
    private final List<PayloadInterceptor> interceptors;
    private final MimeType metadataMimeType;
    private final MimeType dataMimeType;
    private final Context context;

    PayloadInterceptorRSocket(RSocket delegate, List<PayloadInterceptor> interceptors, MimeType metadataMimeType, MimeType dataMimeType) {
        this(delegate, interceptors, metadataMimeType, dataMimeType, Context.empty());
    }

    PayloadInterceptorRSocket(RSocket delegate, List<PayloadInterceptor> interceptors, MimeType metadataMimeType, MimeType dataMimeType, Context context) {
        super(delegate);
        this.metadataMimeType = metadataMimeType;
        this.dataMimeType = dataMimeType;
        if (delegate == null) {
            throw new IllegalArgumentException("delegate cannot be null");
        }
        if (interceptors == null) {
            throw new IllegalArgumentException("interceptors cannot be null");
        }
        if (interceptors.isEmpty()) {
            throw new IllegalArgumentException("interceptors cannot be empty");
        }
        this.interceptors = interceptors;
        this.context = context;
    }

    public Mono<Void> fireAndForget(Payload payload) {
        return this.intercept(PayloadExchangeType.FIRE_AND_FORGET, payload).flatMap(context -> this.source.fireAndForget(payload).subscriberContext(context));
    }

    public Mono<Payload> requestResponse(Payload payload) {
        return this.intercept(PayloadExchangeType.REQUEST_RESPONSE, payload).flatMap(context -> this.source.requestResponse(payload).subscriberContext(context));
    }

    public Flux<Payload> requestStream(Payload payload) {
        return this.intercept(PayloadExchangeType.REQUEST_STREAM, payload).flatMapMany(context -> this.source.requestStream(payload).subscriberContext(context));
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return Flux.from(payloads).switchOnFirst((signal, innerFlux) -> {
            Payload firstPayload = (Payload)signal.get();
            return this.intercept(PayloadExchangeType.REQUEST_CHANNEL, firstPayload).flatMapMany(context -> innerFlux.index().concatMap(tuple -> this.justOrIntercept((Long)tuple.getT1(), (Payload)tuple.getT2())).transform(securedPayloads -> this.source.requestChannel((Publisher)securedPayloads)).subscriberContext(context));
        });
    }

    private Mono<Payload> justOrIntercept(Long index, Payload payload) {
        return index == 0L ? Mono.just((Object)payload) : this.intercept(PayloadExchangeType.PAYLOAD, payload).thenReturn((Object)payload);
    }

    public Mono<Void> metadataPush(Payload payload) {
        return this.intercept(PayloadExchangeType.METADATA_PUSH, payload).flatMap(c -> this.source.metadataPush(payload).subscriberContext(c));
    }

    private Mono<Context> intercept(PayloadExchangeType type, Payload payload) {
        return Mono.defer(() -> {
            ContextPayloadInterceptorChain chain = new ContextPayloadInterceptorChain(this.interceptors);
            DefaultPayloadExchange exchange = new DefaultPayloadExchange(type, payload, this.metadataMimeType, this.dataMimeType);
            return chain.next(exchange).then(Mono.fromCallable(() -> chain.getContext())).defaultIfEmpty((Object)Context.empty()).subscriberContext(this.context);
        });
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[source=" + this.source + ",interceptors=" + this.interceptors + "]";
    }
}

