/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.remoting.dns;

import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.springframework.security.remoting.dns.DnsEntryNotFoundException;
import org.springframework.security.remoting.dns.DnsLookupException;
import org.springframework.security.remoting.dns.DnsResolver;
import org.springframework.security.remoting.dns.InitialContextFactory;

@Deprecated
public class JndiDnsResolver
implements DnsResolver {
    private InitialContextFactory ctxFactory = new DefaultInitialContextFactory();
    private static final int SERVICE_RECORD_PRIORITY_INDEX = 0;
    private static final int SERVICE_RECORD_WEIGHT_INDEX = 1;
    private static final int SERVICE_RECORD_PORT_INDEX = 2;
    private static final int SERVICE_RECORD_TARGET_INDEX = 3;

    public void setCtxFactory(InitialContextFactory ctxFactory) {
        this.ctxFactory = ctxFactory;
    }

    @Override
    public String resolveIpAddress(String hostname) {
        return this.resolveIpAddress(hostname, this.ctxFactory.getCtx());
    }

    @Override
    public String resolveServiceEntry(String serviceType, String domain) {
        return this.resolveServiceEntry(serviceType, domain, this.ctxFactory.getCtx()).getHostName();
    }

    @Override
    public String resolveServiceIpAddress(String serviceType, String domain) {
        DirContext ctx = this.ctxFactory.getCtx();
        String hostname = this.resolveServiceEntry(serviceType, domain, ctx).getHostName();
        return this.resolveIpAddress(hostname, ctx);
    }

    public String resolveServiceIpAddressAndPort(String serviceType, String domain) {
        DirContext ctx = this.ctxFactory.getCtx();
        ConnectionInfo hostInfo = this.resolveServiceEntry(serviceType, domain, ctx);
        return this.resolveIpAddress(hostInfo.getHostName(), ctx) + ":" + hostInfo.getPort();
    }

    private String resolveIpAddress(String hostname, DirContext ctx) {
        try {
            Attribute dnsRecord = this.lookup(hostname, ctx, "A");
            return dnsRecord.get().toString();
        }
        catch (NamingException ex) {
            throw new DnsLookupException("DNS lookup failed for: " + hostname, ex);
        }
    }

    private ConnectionInfo resolveServiceEntry(String serviceType, String domain, DirContext ctx) {
        String target = null;
        String port = null;
        try {
            String query = "_" + serviceType + "._tcp." + domain;
            Attribute dnsRecord = this.lookup(query, ctx, "SRV");
            int highestPriority = -1;
            int highestWeight = -1;
            NamingEnumeration<?> recordEnum = dnsRecord.getAll();
            while (recordEnum.hasMoreElements()) {
                Object[] record = recordEnum.next().toString().split(" ");
                if (record.length != 4) {
                    throw new DnsLookupException("Wrong service record for query " + query + ": [" + Arrays.toString(record) + "]");
                }
                int priority = Integer.parseInt(record[0]);
                int weight = Integer.parseInt(record[1]);
                if (priority < highestPriority || highestPriority == -1) {
                    highestPriority = priority;
                    highestWeight = weight;
                    target = ((String)record[3]).trim();
                    port = ((String)record[2]).trim();
                }
                if (priority != highestPriority || weight <= highestWeight) continue;
                highestWeight = weight;
                target = ((String)record[3]).trim();
                port = ((String)record[2]).trim();
            }
        }
        catch (NamingException ex) {
            throw new DnsLookupException("DNS lookup failed for service " + serviceType + " at " + domain, ex);
        }
        if (target.endsWith(".")) {
            target = target.substring(0, target.length() - 1);
        }
        return new ConnectionInfo(target, port);
    }

    private Attribute lookup(String query, DirContext ictx, String recordType) {
        try {
            Attributes dnsResult = ictx.getAttributes(query, new String[]{recordType});
            return dnsResult.get(recordType);
        }
        catch (NamingException ex) {
            if (ex instanceof NameNotFoundException) {
                throw new DnsEntryNotFoundException("DNS entry not found for:" + query, ex);
            }
            throw new DnsLookupException("DNS lookup failed for: " + query, ex);
        }
    }

    private static class ConnectionInfo {
        private final String hostName;
        private final String port;

        ConnectionInfo(String hostName, String port) {
            this.hostName = hostName;
            this.port = port;
        }

        String getHostName() {
            return this.hostName;
        }

        String getPort() {
            return this.port;
        }
    }

    private static class DefaultInitialContextFactory
    implements InitialContextFactory {
        private DefaultInitialContextFactory() {
        }

        @Override
        public DirContext getCtx() {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            try {
                return new InitialDirContext(env);
            }
            catch (NamingException ex) {
                throw new DnsLookupException("Cannot create InitialDirContext for DNS lookup", ex);
            }
        }
    }
}

