/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import java.io.Serializable;
import java.util.List;
import org.springframework.util.Assert;

public class OpenIDAttribute
implements Serializable {
    private final String name;
    private final String typeIdentifier;
    private boolean required = false;
    private int count = 1;
    private final List<String> values;

    public OpenIDAttribute(String name, String type) {
        this.name = name;
        this.typeIdentifier = type;
        this.values = null;
    }

    public OpenIDAttribute(String name, String type, List<String> values) {
        Assert.notEmpty(values, (String)"values cannot be empty");
        this.name = name;
        this.typeIdentifier = type;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.typeIdentifier;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<String> getValues() {
        Assert.notNull(this.values, (String)"Cannot read values from an authentication request attribute");
        return this.values;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.name);
        if (this.values != null) {
            result.append(":");
            result.append(this.values.toString());
        }
        result.append("]");
        return result.toString();
    }
}

