/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.server.authentication;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerBearerTokenAuthenticationConverter
implements ServerAuthenticationConverter {
    private static final String ACCESS_TOKEN_PARAMETER_NAME = "access_token";
    private static final Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+=*)$", 2);
    private boolean allowFormEncodedBodyParameter = false;
    private boolean allowUriQueryParameter = false;
    private String bearerTokenHeaderName = "Authorization";

    public Mono<Authentication> convert(ServerWebExchange exchange) {
        return Mono.defer(() -> {
            ServerHttpRequest request = exchange.getRequest();
            return Flux.merge((Publisher[])new Publisher[]{this.resolveFromAuthorizationHeader(request.getHeaders()), this.resolveAccessTokenFromQueryString(request), this.resolveAccessTokenFromBody(exchange)}).collectList().flatMap(ServerBearerTokenAuthenticationConverter::resolveToken).map(BearerTokenAuthenticationToken::new);
        });
    }

    private static Mono<String> resolveToken(List<String> accessTokens) {
        if (CollectionUtils.isEmpty(accessTokens)) {
            return Mono.empty();
        }
        if (accessTokens.size() > 1) {
            BearerTokenError error = BearerTokenErrors.invalidRequest("Found multiple bearer tokens in the request");
            return Mono.error((Throwable)new OAuth2AuthenticationException((OAuth2Error)error));
        }
        String accessToken = accessTokens.get(0);
        if (!StringUtils.hasText((String)accessToken)) {
            BearerTokenError error = BearerTokenErrors.invalidRequest("The requested token parameter is an empty string");
            return Mono.error((Throwable)new OAuth2AuthenticationException((OAuth2Error)error));
        }
        return Mono.just((Object)accessToken);
    }

    private Mono<String> resolveFromAuthorizationHeader(HttpHeaders headers) {
        String authorization = headers.getFirst(this.bearerTokenHeaderName);
        if (!StringUtils.startsWithIgnoreCase((String)authorization, (String)"bearer")) {
            return Mono.empty();
        }
        Matcher matcher = authorizationPattern.matcher(authorization);
        if (!matcher.matches()) {
            BearerTokenError error = BearerTokenErrors.invalidToken("Bearer token is malformed");
            throw new OAuth2AuthenticationException((OAuth2Error)error);
        }
        return Mono.just((Object)matcher.group("token"));
    }

    private Flux<String> resolveAccessTokenFromQueryString(ServerHttpRequest request) {
        if (!this.allowUriQueryParameter || !HttpMethod.GET.equals((Object)request.getMethod())) {
            return Flux.empty();
        }
        return ServerBearerTokenAuthenticationConverter.resolveTokens((MultiValueMap<String, String>)request.getQueryParams());
    }

    private Flux<String> resolveAccessTokenFromBody(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        if (!(this.allowFormEncodedBodyParameter && MediaType.APPLICATION_FORM_URLENCODED.equals((Object)request.getHeaders().getContentType()) && HttpMethod.POST.equals((Object)request.getMethod()))) {
            return Flux.empty();
        }
        return exchange.getFormData().flatMapMany(ServerBearerTokenAuthenticationConverter::resolveTokens);
    }

    private static Flux<String> resolveTokens(MultiValueMap<String, String> parameters) {
        List accessTokens = (List)parameters.get((Object)ACCESS_TOKEN_PARAMETER_NAME);
        return CollectionUtils.isEmpty((Collection)accessTokens) ? Flux.empty() : Flux.fromIterable((Iterable)accessTokens);
    }

    public void setAllowUriQueryParameter(boolean allowUriQueryParameter) {
        this.allowUriQueryParameter = allowUriQueryParameter;
    }

    public void setBearerTokenHeaderName(String bearerTokenHeaderName) {
        this.bearerTokenHeaderName = bearerTokenHeaderName;
    }

    public void setAllowFormEncodedBodyParameter(boolean allowFormEncodedBodyParameter) {
        this.allowFormEncodedBodyParameter = allowFormEncodedBodyParameter;
    }
}

