/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.StringUtils;

public final class BearerTokenAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private String realmName;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpStatus status = HttpStatus.UNAUTHORIZED;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.realmName != null) {
            parameters.put("realm", this.realmName);
        }
        if (authException instanceof OAuth2AuthenticationException) {
            OAuth2Error error = ((OAuth2AuthenticationException)((Object)authException)).getError();
            parameters.put("error", error.getErrorCode());
            if (StringUtils.hasText((String)error.getDescription())) {
                parameters.put("error_description", error.getDescription());
            }
            if (StringUtils.hasText((String)error.getUri())) {
                parameters.put("error_uri", error.getUri());
            }
            if (error instanceof BearerTokenError) {
                BearerTokenError bearerTokenError = (BearerTokenError)error;
                if (StringUtils.hasText((String)bearerTokenError.getScope())) {
                    parameters.put("scope", bearerTokenError.getScope());
                }
                status = ((BearerTokenError)error).getHttpStatus();
            }
        }
        String wwwAuthenticate = BearerTokenAuthenticationEntryPoint.computeWWWAuthenticateHeaderValue(parameters);
        response.addHeader("WWW-Authenticate", wwwAuthenticate);
        response.setStatus(status.value());
    }

    public final void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    private static String computeWWWAuthenticateHeaderValue(Map<String, String> parameters) {
        String wwwAuthenticate = "Bearer";
        if (!parameters.isEmpty()) {
            wwwAuthenticate = wwwAuthenticate + parameters.entrySet().stream().map(attribute -> (String)attribute.getKey() + "=\"" + (String)attribute.getValue() + "\"").collect(Collectors.joining(", ", " ", ""));
        }
        return wwwAuthenticate;
    }
}

