/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.security.oauth2.jwt.ReactiveJWKSource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

class ReactiveRemoteJWKSource
implements ReactiveJWKSource {
    private final AtomicReference<Mono<JWKSet>> cachedJWKSet = new AtomicReference<Mono>(Mono.empty());
    private final AtomicReference<String> cachedJwkSetUrl = new AtomicReference();
    private WebClient webClient = WebClient.create();
    private final Mono<String> jwkSetUrlProvider;

    ReactiveRemoteJWKSource(String jwkSetURL) {
        Assert.hasText((String)jwkSetURL, (String)"jwkSetURL cannot be empty");
        this.jwkSetUrlProvider = Mono.just((Object)jwkSetURL);
    }

    ReactiveRemoteJWKSource(Mono<String> jwkSetUrlProvider) {
        Assert.notNull(jwkSetUrlProvider, (String)"jwkSetUrlProvider cannot be null");
        this.jwkSetUrlProvider = Mono.fromCallable(this.cachedJwkSetUrl::get).switchIfEmpty(Mono.defer(() -> jwkSetUrlProvider.doOnNext(this.cachedJwkSetUrl::set)));
    }

    @Override
    public Mono<List<JWK>> get(JWKSelector jwkSelector) {
        return this.cachedJWKSet.get().switchIfEmpty(Mono.defer(this::getJWKSet)).flatMap(jwkSet -> this.get(jwkSelector, (JWKSet)jwkSet)).switchIfEmpty(Mono.defer(() -> this.getJWKSet().map(arg_0 -> ((JWKSelector)jwkSelector).select(arg_0))));
    }

    private Mono<List<JWK>> get(JWKSelector jwkSelector, JWKSet jwkSet) {
        return Mono.defer(() -> {
            List matches = jwkSelector.select(jwkSet);
            if (!matches.isEmpty()) {
                return Mono.just((Object)matches);
            }
            String soughtKeyID = ReactiveRemoteJWKSource.getFirstSpecifiedKeyID(jwkSelector.getMatcher());
            if (soughtKeyID == null) {
                return Mono.just(Collections.emptyList());
            }
            if (jwkSet.getKeyByKeyId(soughtKeyID) != null) {
                return Mono.just(Collections.emptyList());
            }
            return Mono.empty();
        });
    }

    private Mono<JWKSet> getJWKSet() {
        return this.jwkSetUrlProvider.flatMap(jwkSetURL -> this.webClient.get().uri(jwkSetURL, new Object[0]).retrieve().bodyToMono(String.class)).map(this::parse).doOnNext(jwkSet -> this.cachedJWKSet.set((Mono<JWKSet>)Mono.just((Object)jwkSet))).cache();
    }

    private JWKSet parse(String body) {
        try {
            return JWKSet.parse((String)body);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jwkMatcher) {
        Set keyIDs = jwkMatcher.getKeyIDs();
        if (keyIDs == null || keyIDs.isEmpty()) {
            return null;
        }
        for (String id : keyIDs) {
            if (id == null) continue;
            return id;
        }
        return null;
    }

    void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }
}

