/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public final class JwtTimestampValidator
implements OAuth2TokenValidator<Jwt> {
    private static final Duration DEFAULT_MAX_CLOCK_SKEW = Duration.of(60L, ChronoUnit.SECONDS);
    private final Duration maxClockSkew;
    private Clock clock = Clock.systemUTC();

    public JwtTimestampValidator() {
        this(DEFAULT_MAX_CLOCK_SKEW);
    }

    public JwtTimestampValidator(Duration maxClockSkew) {
        Assert.notNull((Object)maxClockSkew, (String)"maxClockSkew cannot be null");
        this.maxClockSkew = maxClockSkew;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        Assert.notNull((Object)jwt, (String)"jwt cannot be null");
        Instant expiry = jwt.getExpiresAt();
        if (expiry != null && Instant.now(this.clock).minus(this.maxClockSkew).isAfter(expiry)) {
            OAuth2Error error = new OAuth2Error("invalid_request", String.format("Jwt expired at %s", jwt.getExpiresAt()), "https://tools.ietf.org/html/rfc6750#section-3.1");
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
        Instant notBefore = jwt.getNotBefore();
        if (notBefore != null && Instant.now(this.clock).plus(this.maxClockSkew).isBefore(notBefore)) {
            OAuth2Error error = new OAuth2Error("invalid_request", String.format("Jwt used before %s", jwt.getNotBefore()), "https://tools.ietf.org/html/rfc6750#section-3.1");
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
        return OAuth2TokenValidatorResult.success();
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

