/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public final class JwtIssuerValidator
implements OAuth2TokenValidator<Jwt> {
    private static OAuth2Error INVALID_ISSUER = new OAuth2Error("invalid_request", "This iss claim is not equal to the configured issuer", "https://tools.ietf.org/html/rfc6750#section-3.1");
    private final URL issuer;

    public JwtIssuerValidator(String issuer) {
        Assert.notNull((Object)issuer, (String)"issuer cannot be null");
        try {
            this.issuer = new URL(issuer);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid Issuer URL " + issuer + " : " + ex.getMessage(), ex);
        }
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Assert.notNull((Object)token, (String)"token cannot be null");
        if (this.issuer.equals(token.getIssuer())) {
            return OAuth2TokenValidatorResult.success();
        }
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{INVALID_ISSUER});
    }
}

