/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Deprecated(since="6.4")
public class TokenExchangeGrantRequestEntityConverter
extends AbstractOAuth2AuthorizationGrantRequestEntityConverter<TokenExchangeGrantRequest> {
    private static final String ACCESS_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String JWT_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:jwt";

    @Override
    protected MultiValueMap<String, String> createParameters(TokenExchangeGrantRequest grantRequest) {
        ClientRegistration clientRegistration = grantRequest.getClientRegistration();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"grant_type", (Object)grantRequest.getGrantType().getValue());
        parameters.add((Object)"requested_token_type", (Object)ACCESS_TOKEN_TYPE_VALUE);
        OAuth2Token subjectToken = grantRequest.getSubjectToken();
        parameters.add((Object)"subject_token", (Object)subjectToken.getTokenValue());
        parameters.add((Object)"subject_token_type", (Object)TokenExchangeGrantRequestEntityConverter.tokenType(subjectToken));
        OAuth2Token actorToken = grantRequest.getActorToken();
        if (actorToken != null) {
            parameters.add((Object)"actor_token", (Object)actorToken.getTokenValue());
            parameters.add((Object)"actor_token_type", (Object)TokenExchangeGrantRequestEntityConverter.tokenType(actorToken));
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            parameters.add((Object)"scope", (Object)StringUtils.collectionToDelimitedString(clientRegistration.getScopes(), (String)" "));
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            parameters.add((Object)"client_id", (Object)clientRegistration.getClientId());
            parameters.add((Object)"client_secret", (Object)clientRegistration.getClientSecret());
        }
        return parameters;
    }

    private static String tokenType(OAuth2Token token) {
        return token instanceof Jwt ? JWT_TOKEN_TYPE_VALUE : ACCESS_TOKEN_TYPE_VALUE;
    }
}

