/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import java.util.function.Function;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.JwtBearerGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveJwtBearerTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class JwtBearerReactiveOAuth2AuthorizedClientProvider
implements ReactiveOAuth2AuthorizedClientProvider {
    private ReactiveOAuth2AccessTokenResponseClient<JwtBearerGrantRequest> accessTokenResponseClient = new WebClientReactiveJwtBearerTokenResponseClient();
    private Function<OAuth2AuthorizationContext, Mono<Jwt>> jwtAssertionResolver = this::resolveJwtAssertion;
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        ClientRegistration clientRegistration = context.getClientRegistration();
        if (!AuthorizationGrantType.JWT_BEARER.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            return Mono.empty();
        }
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (authorizedClient != null && !this.hasTokenExpired((OAuth2Token)authorizedClient.getAccessToken())) {
            return Mono.empty();
        }
        return this.jwtAssertionResolver.apply(context).map(jwt -> new JwtBearerGrantRequest(clientRegistration, (Jwt)jwt)).flatMap(this.accessTokenResponseClient::getTokenResponse).onErrorMap(OAuth2AuthorizationException.class, ex -> new ClientAuthorizationException(ex.getError(), clientRegistration.getRegistrationId(), (Throwable)ex)).map(tokenResponse -> new OAuth2AuthorizedClient(clientRegistration, context.getPrincipal().getName(), tokenResponse.getAccessToken()));
    }

    private Mono<Jwt> resolveJwtAssertion(OAuth2AuthorizationContext context) {
        return Mono.just((Object)context).map(ctx -> ctx.getPrincipal().getPrincipal()).filter(principal -> principal instanceof Jwt).cast(Jwt.class);
    }

    private boolean hasTokenExpired(OAuth2Token token) {
        return this.clock.instant().isAfter(token.getExpiresAt().minus(this.clockSkew));
    }

    public void setAccessTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<JwtBearerGrantRequest> accessTokenResponseClient) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public void setJwtAssertionResolver(Function<OAuth2AuthorizationContext, Mono<Jwt>> jwtAssertionResolver) {
        Assert.notNull(jwtAssertionResolver, (String)"jwtAssertionResolver cannot be null");
        this.jwtAssertionResolver = jwtAssertionResolver;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

