/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SimpMessageTypeMatcher
implements MessageMatcher<Object> {
    private final SimpMessageType typeToMatch;

    public SimpMessageTypeMatcher(SimpMessageType typeToMatch) {
        Assert.notNull((Object)typeToMatch, (String)"typeToMatch cannot be null");
        this.typeToMatch = typeToMatch;
    }

    @Override
    public boolean matches(Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        SimpMessageType messageType = SimpMessageHeaderAccessor.getMessageType((Map)headers);
        return this.typeToMatch == messageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpMessageTypeMatcher)) {
            return false;
        }
        SimpMessageTypeMatcher otherMatcher = (SimpMessageTypeMatcher)other;
        return ObjectUtils.nullSafeEquals((Object)this.typeToMatch, (Object)otherMatcher.typeToMatch);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.typeToMatch);
    }

    public String toString() {
        return "SimpMessageTypeMatcher [typeToMatch=" + String.valueOf(this.typeToMatch) + "]";
    }
}

