/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.List;
import org.springframework.core.log.LogMessage;
import org.springframework.messaging.Message;
import org.springframework.security.messaging.util.matcher.AbstractMessageMatcherComposite;
import org.springframework.security.messaging.util.matcher.MessageMatcher;

public final class OrMessageMatcher<T>
extends AbstractMessageMatcherComposite<T> {
    public OrMessageMatcher(List<MessageMatcher<T>> messageMatchers) {
        super(messageMatchers);
    }

    @SafeVarargs
    public OrMessageMatcher(MessageMatcher<T> ... messageMatchers) {
        super(messageMatchers);
    }

    @Override
    public boolean matches(Message<? extends T> message) {
        for (MessageMatcher<? extends T> messageMatcher : this.getMessageMatchers()) {
            this.logger.debug((Object)LogMessage.format((String)"Trying to match using %s", messageMatcher));
            if (!messageMatcher.matches(message)) continue;
            this.logger.debug((Object)"matched");
            return true;
        }
        this.logger.debug((Object)"No matches found");
        return false;
    }
}

