/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.util.Assert;

public abstract class AbstractMessageMatcherComposite<T>
implements MessageMatcher<T> {
    protected final Log logger;
    @Deprecated
    protected final Log LOGGER;
    private final List<MessageMatcher<T>> messageMatchers;

    AbstractMessageMatcherComposite(List<MessageMatcher<T>> messageMatchers) {
        this.LOGGER = this.logger = LogFactory.getLog(this.getClass());
        Assert.notEmpty(messageMatchers, (String)"messageMatchers must contain a value");
        Assert.isTrue((!messageMatchers.contains(null) ? 1 : 0) != 0, (String)"messageMatchers cannot contain null values");
        this.messageMatchers = messageMatchers;
    }

    @SafeVarargs
    AbstractMessageMatcherComposite(MessageMatcher<T> ... messageMatchers) {
        this(Arrays.asList(messageMatchers));
    }

    public List<MessageMatcher<T>> getMessageMatchers() {
        return this.messageMatchers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[messageMatchers=" + String.valueOf(this.messageMatchers) + "]";
    }
}

