/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.context;

import java.util.Collection;
import java.util.Stack;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public final class SecurityContextChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    private final SecurityContext EMPTY_CONTEXT = SecurityContextHolder.createEmptyContext();
    private static final ThreadLocal<Stack<SecurityContext>> ORIGINAL_CONTEXT = new ThreadLocal();
    private final String authenticationHeaderName;
    private Authentication anonymous = new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public SecurityContextChannelInterceptor() {
        this("simpUser");
    }

    public SecurityContextChannelInterceptor(String authenticationHeaderName) {
        Assert.notNull((Object)authenticationHeaderName, (String)"authenticationHeaderName cannot be null");
        this.authenticationHeaderName = authenticationHeaderName;
    }

    public void setAnonymousAuthentication(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.anonymous = authentication;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        this.setup(message);
        return message;
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        this.cleanup();
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        this.setup(message);
        return message;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        this.cleanup();
    }

    private void setup(Message<?> message) {
        SecurityContext currentContext = SecurityContextHolder.getContext();
        Stack<Object> contextStack = ORIGINAL_CONTEXT.get();
        if (contextStack == null) {
            contextStack = new Stack();
            ORIGINAL_CONTEXT.set(contextStack);
        }
        contextStack.push(currentContext);
        Object user = message.getHeaders().get((Object)this.authenticationHeaderName);
        Authentication authentication = user instanceof Authentication ? (Authentication)user : this.anonymous;
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authentication);
        SecurityContextHolder.setContext((SecurityContext)context);
    }

    private void cleanup() {
        Stack<SecurityContext> contextStack = ORIGINAL_CONTEXT.get();
        if (contextStack == null || contextStack.isEmpty()) {
            SecurityContextHolder.clearContext();
            ORIGINAL_CONTEXT.remove();
            return;
        }
        SecurityContext originalContext = contextStack.pop();
        try {
            if (this.EMPTY_CONTEXT.equals(originalContext)) {
                SecurityContextHolder.clearContext();
                ORIGINAL_CONTEXT.remove();
            } else {
                SecurityContextHolder.setContext((SecurityContext)originalContext);
            }
        }
        catch (Throwable t) {
            SecurityContextHolder.clearContext();
        }
    }
}

