/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.ldap.LdapEncoder;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SpringSecurityLdapTemplate
extends LdapTemplate {
    private static final Log logger = LogFactory.getLog(SpringSecurityLdapTemplate.class);
    public static final String[] NO_ATTRS = new String[0];
    public static final String DN_KEY = "spring.security.ldap.dn";
    private static final boolean RETURN_OBJECT = true;
    private SearchControls searchControls = new SearchControls();

    public SpringSecurityLdapTemplate(ContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"ContextSource cannot be null");
        this.setContextSource(contextSource);
        this.searchControls.setSearchScope(2);
    }

    public boolean compare(String dn, String attributeName, Object value) {
        String comparisonFilter = "(" + attributeName + "={0})";
        return (Boolean)this.executeReadOnly(ctx -> {
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(NO_ATTRS);
            searchControls.setSearchScope(0);
            Object[] params = new Object[]{value};
            NamingEnumeration<SearchResult> results = ctx.search(dn, comparisonFilter, params, searchControls);
            Boolean match = results.hasMore();
            LdapUtils.closeEnumeration(results);
            return match;
        });
    }

    public DirContextOperations retrieveEntry(String dn, String[] attributesToRetrieve) {
        return (DirContextOperations)this.executeReadOnly(ctx -> {
            Attributes attrs = ctx.getAttributes(dn, attributesToRetrieve);
            return new DirContextAdapter(attrs, (Name)new DistinguishedName(dn), (Name)new DistinguishedName(ctx.getNameInNamespace()));
        });
    }

    public Set<String> searchForSingleAttributeValues(String base, String filter, Object[] params, String attributeName) {
        String[] attributeNames = new String[]{attributeName};
        Set<Map<String, List<String>>> multipleAttributeValues = this.searchForMultipleAttributeValues(base, filter, params, attributeNames);
        HashSet<String> result = new HashSet<String>();
        for (Map<String, List<String>> map : multipleAttributeValues) {
            List<String> values = map.get(attributeName);
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    public Set<Map<String, List<String>>> searchForMultipleAttributeValues(String base, String filter, Object[] params, String[] attributeNames) {
        Object[] encodedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            encodedParams[i] = LdapEncoder.filterEncode(params[i].toString());
        }
        String formattedFilter = MessageFormat.format(filter, encodedParams);
        logger.debug((Object)LogMessage.format((String)"Using filter: %s", (Object)formattedFilter));
        HashSet<Map<String, List<String>>> result = new HashSet<Map<String, List<String>>>();
        ContextMapper roleMapper = ctx -> {
            DirContextAdapter adapter = (DirContextAdapter)ctx;
            HashMap<String, List<String>> record = new HashMap<String, List<String>>();
            if (ObjectUtils.isEmpty((Object[])attributeNames)) {
                try {
                    NamingEnumeration<? extends Attribute> enumeration = adapter.getAttributes().getAll();
                    while (enumeration.hasMore()) {
                        Attribute attr = enumeration.next();
                        this.extractStringAttributeValues(adapter, record, attr.getID());
                    }
                }
                catch (NamingException ex) {
                    org.springframework.ldap.support.LdapUtils.convertLdapException((NamingException)ex);
                }
            } else {
                for (String attributeName : attributeNames) {
                    this.extractStringAttributeValues(adapter, record, attributeName);
                }
            }
            record.put(DN_KEY, Arrays.asList(this.getAdapterDN(adapter)));
            result.add(record);
            return null;
        };
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(this.searchControls.getSearchScope());
        ctls.setReturningAttributes(attributeNames != null && attributeNames.length > 0 ? attributeNames : null);
        this.search(base, formattedFilter, ctls, roleMapper);
        return result;
    }

    private String getAdapterDN(DirContextAdapter adapter) {
        return adapter.getNameInNamespace();
    }

    private void extractStringAttributeValues(DirContextAdapter adapter, Map<String, List<String>> record, String attributeName) {
        Object[] values = adapter.getObjectAttributes(attributeName);
        if (values == null || values.length == 0) {
            logger.debug((Object)LogMessage.format((String)"No attribute value found for '%s'", (Object)attributeName));
            return;
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Object value : values) {
            if (value == null) continue;
            if (String.class.isAssignableFrom(value.getClass())) {
                stringValues.add((String)value);
                continue;
            }
            logger.debug((Object)LogMessage.format((String)"Attribute:%s contains a non string value of type[%s]", (Object)attributeName, value.getClass()));
            stringValues.add(value.toString());
        }
        record.put(attributeName, stringValues);
    }

    public DirContextOperations searchForSingleEntry(String base, String filter, Object[] params) {
        return (DirContextOperations)this.executeReadOnly(ctx -> SpringSecurityLdapTemplate.searchForSingleEntryInternal(ctx, this.searchControls, base, filter, params));
    }

    public static DirContextOperations searchForSingleEntryInternal(DirContext ctx, SearchControls searchControls, String base, String filter, Object[] params) throws NamingException {
        DistinguishedName ctxBaseDn = new DistinguishedName(ctx.getNameInNamespace());
        DistinguishedName searchBaseDn = new DistinguishedName(base);
        NamingEnumeration<SearchResult> resultsEnum = ctx.search((Name)searchBaseDn, filter, params, SpringSecurityLdapTemplate.buildControls(searchControls));
        logger.debug((Object)LogMessage.format((String)"Searching for entry under DN '%s', base = '%s', filter = '%s'", (Object)ctxBaseDn, (Object)searchBaseDn, (Object)filter));
        HashSet<DirContextAdapter> results = new HashSet<DirContextAdapter>();
        try {
            while (resultsEnum.hasMore()) {
                SearchResult searchResult = resultsEnum.next();
                DirContextAdapter dca = (DirContextAdapter)searchResult.getObject();
                Assert.notNull((Object)dca, (String)"No object returned by search, DirContext is not correctly configured");
                logger.debug((Object)LogMessage.format((String)"Found DN: %s", (Object)dca.getDn()));
                results.add(dca);
            }
        }
        catch (PartialResultException ex) {
            LdapUtils.closeEnumeration(resultsEnum);
            logger.info((Object)"Ignoring PartialResultException");
        }
        if (results.size() != 1) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return (DirContextOperations)results.iterator().next();
    }

    private static SearchControls buildControls(SearchControls originalControls) {
        return new SearchControls(originalControls.getSearchScope(), originalControls.getCountLimit(), originalControls.getTimeLimit(), originalControls.getReturningAttributes(), true, originalControls.getDerefLinkFlag());
    }

    public void setSearchControls(SearchControls searchControls) {
        this.searchControls = searchControls;
    }
}

