/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.server.KdcConfigKey;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.apache.kerby.util.IOUtil;
import org.apache.kerby.util.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniKdc {
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private static final Logger LOG = LoggerFactory.getLogger(MiniKdc.class);
    public static final String ORG_NAME = "org.name";
    public static final String ORG_DOMAIN = "org.domain";
    public static final String KDC_BIND_ADDRESS = "kdc.bind.address";
    public static final String KDC_PORT = "kdc.port";
    public static final String INSTANCE = "instance";
    public static final String MAX_TICKET_LIFETIME = "max.ticket.lifetime";
    public static final String MIN_TICKET_LIFETIME = "min.ticket.lifetime";
    public static final String MAX_RENEWABLE_LIFETIME = "max.renewable.lifetime";
    public static final String TRANSPORT = "transport";
    public static final String DEBUG = "debug";
    private static final Set<String> PROPERTIES = new HashSet<String>();
    private static final Properties DEFAULT_CONFIG = new Properties();
    private Properties conf;
    private SimpleKdcServer simpleKdc;
    private int port;
    private String realm;
    private File workDir;
    private File krb5conf;
    private String transport;
    private boolean krb5Debug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File workDir;
        if (args.length < 4) {
            System.out.println("Arguments: <WORKDIR> <MINIKDCPROPERTIES> <KEYTABFILE> [<PRINCIPALS>]+");
            System.exit(1);
        }
        if (!(workDir = new File(args[0])).exists()) {
            throw new RuntimeException("Specified work directory does not exists: " + workDir.getAbsolutePath());
        }
        Properties conf = MiniKdc.createConf();
        File file = new File(args[1]);
        if (!file.exists()) {
            throw new RuntimeException("Specified configuration does not exists: " + file.getAbsolutePath());
        }
        Properties userConf = new Properties();
        try (InputStreamReader r = null;){
            r = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            userConf.load(r);
        }
        for (Map.Entry<Object, Object> entry : userConf.entrySet()) {
            conf.put(entry.getKey(), entry.getValue());
        }
        final MiniKdc miniKdc = new MiniKdc(conf, workDir);
        miniKdc.start();
        File krb5conf = new File(workDir, "krb5.conf");
        if (!miniKdc.getKrb5conf().renameTo(krb5conf)) {
            throw new RuntimeException("Cannot rename KDC's krb5conf to " + krb5conf.getAbsolutePath());
        }
        File keytabFile = new File(args[2]).getAbsoluteFile();
        String[] principals = new String[args.length - 3];
        System.arraycopy(args, 3, principals, 0, args.length - 3);
        miniKdc.createPrincipal(keytabFile, principals);
        System.out.println();
        System.out.println("Standalone MiniKdc Running");
        System.out.println("---------------------------------------------------");
        System.out.println("  Realm           : " + miniKdc.getRealm());
        System.out.println("  Running at      : " + miniKdc.getHost() + ":" + miniKdc.getPort());
        System.out.println("  krb5conf        : " + String.valueOf(krb5conf));
        System.out.println();
        System.out.println("  created keytab  : " + String.valueOf(keytabFile));
        System.out.println("  with principals : " + String.valueOf(Arrays.asList(principals)));
        System.out.println();
        System.out.println(" Do <CTRL-C> or kill <PID> to stop it");
        System.out.println("---------------------------------------------------");
        System.out.println();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                miniKdc.stop();
            }
        });
    }

    public static Properties createConf() {
        return (Properties)DEFAULT_CONFIG.clone();
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public MiniKdc(Properties conf, File workDir) throws Exception {
        if (!conf.keySet().containsAll(PROPERTIES)) {
            HashSet<String> missingProperties = new HashSet<String>(PROPERTIES);
            missingProperties.removeAll(conf.keySet());
            throw new IllegalArgumentException("Missing configuration properties: " + String.valueOf(missingProperties));
        }
        this.workDir = new File(workDir, Long.toString(System.currentTimeMillis()));
        if (!this.workDir.exists() && !this.workDir.mkdirs()) {
            throw new RuntimeException("Cannot create directory " + String.valueOf(this.workDir));
        }
        LOG.info("Configuration:");
        LOG.info("---------------------------------------------------------------");
        for (Map.Entry<Object, Object> entry : conf.entrySet()) {
            LOG.info("  {}: {}", entry.getKey(), entry.getValue());
        }
        LOG.info("---------------------------------------------------------------");
        this.conf = conf;
        this.port = Integer.parseInt(conf.getProperty(KDC_PORT));
        String orgName = conf.getProperty(ORG_NAME);
        String orgDomain = conf.getProperty(ORG_DOMAIN);
        this.realm = orgName.toUpperCase(Locale.ENGLISH) + "." + orgDomain.toUpperCase(Locale.ENGLISH);
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.conf.getProperty(KDC_BIND_ADDRESS);
    }

    public String getRealm() {
        return this.realm;
    }

    public File getKrb5conf() {
        this.krb5conf = new File(System.getProperty(JAVA_SECURITY_KRB5_CONF));
        return this.krb5conf;
    }

    public synchronized void start() throws Exception {
        if (this.simpleKdc != null) {
            throw new RuntimeException("Already started");
        }
        this.simpleKdc = new SimpleKdcServer();
        this.prepareKdcServer();
        this.simpleKdc.init();
        this.resetDefaultRealm();
        this.simpleKdc.start();
        LOG.info("MiniKdc started.");
    }

    private void resetDefaultRealm() throws IOException {
        FileInputStream templateResource = new FileInputStream(this.getKrb5conf().getAbsolutePath());
        String content = IOUtil.readInput((InputStream)templateResource);
        content = content.replaceAll("default_realm = .*\n", "default_realm = " + this.getRealm() + "\n");
        IOUtil.writeFile((String)content, (File)this.getKrb5conf());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareKdcServer() throws Exception {
        this.simpleKdc.setWorkDir(this.workDir);
        this.simpleKdc.setKdcHost(this.getHost());
        this.simpleKdc.setKdcRealm(this.realm);
        if (this.transport == null) {
            this.transport = this.conf.getProperty(TRANSPORT);
        }
        if (this.port == 0) {
            this.port = NetworkUtil.getServerPort();
        }
        if (this.transport == null) throw new IllegalArgumentException("Need to set transport!");
        if (this.transport.trim().equals("TCP")) {
            this.simpleKdc.setKdcTcpPort(this.port);
            this.simpleKdc.setAllowUdp(false);
        } else {
            if (!this.transport.trim().equals("UDP")) throw new IllegalArgumentException("Invalid transport: " + this.transport);
            this.simpleKdc.setKdcUdpPort(this.port);
            this.simpleKdc.setAllowTcp(false);
        }
        this.simpleKdc.getKdcConfig().setString((ConfigKey)KdcConfigKey.KDC_SERVICE_NAME, this.conf.getProperty(INSTANCE));
        if (this.conf.getProperty(DEBUG) != null) {
            this.krb5Debug = this.getAndSet(SUN_SECURITY_KRB5_DEBUG, this.conf.getProperty(DEBUG));
        }
        if (this.conf.getProperty(MIN_TICKET_LIFETIME) != null) {
            this.simpleKdc.getKdcConfig().setLong((ConfigKey)KdcConfigKey.MINIMUM_TICKET_LIFETIME, Long.valueOf(Long.parseLong(this.conf.getProperty(MIN_TICKET_LIFETIME))));
        }
        if (this.conf.getProperty(MAX_TICKET_LIFETIME) == null) return;
        this.simpleKdc.getKdcConfig().setLong((ConfigKey)KdcConfigKey.MAXIMUM_TICKET_LIFETIME, Long.valueOf(Long.parseLong(this.conf.getProperty(MAX_TICKET_LIFETIME))));
    }

    public synchronized void stop() {
        if (this.simpleKdc != null) {
            try {
                this.simpleKdc.stop();
            }
            catch (KrbException ex) {
                ex.printStackTrace();
            }
            finally {
                if (this.conf.getProperty(DEBUG) != null) {
                    System.setProperty(SUN_SECURITY_KRB5_DEBUG, Boolean.toString(this.krb5Debug));
                }
            }
        }
        this.delete(this.workDir);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        LOG.info("MiniKdc stopped.");
    }

    private void delete(File f) {
        if (f.isFile()) {
            if (!f.delete()) {
                LOG.warn("WARNING: cannot delete file " + f.getAbsolutePath());
            }
        } else {
            File[] fileList = f.listFiles();
            if (fileList != null) {
                for (File c : fileList) {
                    this.delete(c);
                }
            }
            if (!f.delete()) {
                LOG.warn("WARNING: cannot delete directory " + f.getAbsolutePath());
            }
        }
    }

    public synchronized void createPrincipal(String principal, String password) throws Exception {
        this.simpleKdc.createPrincipal(principal, password);
    }

    public synchronized void createPrincipal(File keytabFile, String ... principals) throws Exception {
        this.simpleKdc.createPrincipals(principals);
        if (keytabFile.exists() && !keytabFile.delete()) {
            LOG.error("Failed to delete keytab file: " + String.valueOf(keytabFile));
        }
        for (String principal : principals) {
            this.simpleKdc.getKadmin().exportKeytab(keytabFile, principal);
        }
    }

    private boolean getAndSet(String sysprop, String debug) {
        boolean old = Boolean.getBoolean(sysprop);
        System.setProperty(sysprop, debug);
        return old;
    }

    static {
        PROPERTIES.add(ORG_NAME);
        PROPERTIES.add(ORG_DOMAIN);
        PROPERTIES.add(KDC_BIND_ADDRESS);
        PROPERTIES.add(KDC_BIND_ADDRESS);
        PROPERTIES.add(KDC_PORT);
        PROPERTIES.add(INSTANCE);
        PROPERTIES.add(TRANSPORT);
        PROPERTIES.add(MAX_TICKET_LIFETIME);
        PROPERTIES.add(MAX_RENEWABLE_LIFETIME);
        DEFAULT_CONFIG.setProperty(KDC_BIND_ADDRESS, "localhost");
        DEFAULT_CONFIG.setProperty(KDC_PORT, "0");
        DEFAULT_CONFIG.setProperty(INSTANCE, "DefaultKrbServer");
        DEFAULT_CONFIG.setProperty(ORG_NAME, "EXAMPLE");
        DEFAULT_CONFIG.setProperty(ORG_DOMAIN, "COM");
        DEFAULT_CONFIG.setProperty(TRANSPORT, "TCP");
        DEFAULT_CONFIG.setProperty(MAX_TICKET_LIFETIME, "86400000");
        DEFAULT_CONFIG.setProperty(MAX_RENEWABLE_LIFETIME, "604800000");
        DEFAULT_CONFIG.setProperty(DEBUG, "false");
    }
}

