/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.UUID;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.authentication.ui.DefaultLoginPageViewFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RememberMeConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<H> {
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private String key;
    private RememberMeServices rememberMeServices;
    private LogoutHandler logoutHandler;
    private String rememberMeParameter = "remember-me";
    private String rememberMeCookieName = "remember-me";
    private PersistentTokenRepository tokenRepository;
    private UserDetailsService userDetailsService;
    private Integer tokenValiditySeconds;
    private Boolean useSecureCookie;

    public RememberMeConfigurer<H> tokenValiditySeconds(int tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
        return this;
    }

    public RememberMeConfigurer<H> useSecureCookie(boolean useSecureCookie) {
        this.useSecureCookie = useSecureCookie;
        return this;
    }

    public RememberMeConfigurer<H> userDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
        return this;
    }

    public RememberMeConfigurer<H> tokenRepository(PersistentTokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
        return this;
    }

    public RememberMeConfigurer<H> key(String key) {
        this.key = key;
        return this;
    }

    public RememberMeConfigurer<H> authenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        return this;
    }

    public RememberMeConfigurer<H> rememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
        return this;
    }

    @Override
    public void init(H http) throws Exception {
        String key = this.getKey();
        RememberMeServices rememberMeServices = this.getRememberMeServices(http, key);
        http.setSharedObject(RememberMeServices.class, (RememberMeServices)rememberMeServices);
        LogoutConfigurer logoutConfigurer = http.getConfigurer(LogoutConfigurer.class);
        if (logoutConfigurer != null) {
            logoutConfigurer.addLogoutHandler(this.logoutHandler);
        }
        RememberMeAuthenticationProvider authenticationProvider = new RememberMeAuthenticationProvider(key);
        authenticationProvider = this.postProcess(authenticationProvider);
        http.authenticationProvider((AuthenticationProvider)authenticationProvider);
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(H http) throws Exception {
        RememberMeAuthenticationFilter rememberMeFilter = new RememberMeAuthenticationFilter(http.getAuthenticationManager(), this.rememberMeServices);
        if (this.authenticationSuccessHandler != null) {
            rememberMeFilter.setAuthenticationSuccessHandler(this.authenticationSuccessHandler);
        }
        rememberMeFilter = this.postProcess(rememberMeFilter);
        http.addFilter((Filter)rememberMeFilter);
    }

    private String getRememberMeParameter() {
        return this.rememberMeParameter;
    }

    private void initDefaultLoginFilter(H http) {
        DefaultLoginPageViewFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageViewFilter.class);
        if (loginPageGeneratingFilter != null) {
            loginPageGeneratingFilter.setRememberMeParameter(this.getRememberMeParameter());
        }
    }

    private RememberMeServices getRememberMeServices(H http, String key) throws Exception {
        if (this.rememberMeServices != null) {
            if (this.rememberMeServices instanceof LogoutHandler && this.logoutHandler == null) {
                this.logoutHandler = (LogoutHandler)this.rememberMeServices;
            }
            return this.rememberMeServices;
        }
        AbstractRememberMeServices tokenRememberMeServices = this.createRememberMeServices(http, key);
        tokenRememberMeServices.setParameter(this.rememberMeParameter);
        tokenRememberMeServices.setCookieName(this.rememberMeCookieName);
        if (this.tokenValiditySeconds != null) {
            tokenRememberMeServices.setTokenValiditySeconds(this.tokenValiditySeconds.intValue());
        }
        if (this.useSecureCookie != null) {
            tokenRememberMeServices.setUseSecureCookie(this.useSecureCookie.booleanValue());
        }
        tokenRememberMeServices.afterPropertiesSet();
        this.logoutHandler = tokenRememberMeServices;
        this.rememberMeServices = tokenRememberMeServices;
        return tokenRememberMeServices;
    }

    private AbstractRememberMeServices createRememberMeServices(H http, String key) throws Exception {
        return this.tokenRepository == null ? this.createTokenBasedRememberMeServices(http, key) : this.createPersistentRememberMeServices(http, key);
    }

    private AbstractRememberMeServices createTokenBasedRememberMeServices(H http, String key) {
        UserDetailsService userDetailsService = this.getUserDetailsService(http);
        return new TokenBasedRememberMeServices(key, userDetailsService);
    }

    private AbstractRememberMeServices createPersistentRememberMeServices(H http, String key) {
        UserDetailsService userDetailsService = this.getUserDetailsService(http);
        return new PersistentTokenBasedRememberMeServices(key, userDetailsService, this.tokenRepository);
    }

    private UserDetailsService getUserDetailsService(H http) {
        if (this.userDetailsService == null) {
            this.userDetailsService = http.getSharedObject(UserDetailsService.class);
        }
        if (this.userDetailsService == null) {
            throw new IllegalStateException("userDetailsService cannot be null. Invoke " + RememberMeConfigurer.class.getSimpleName() + "#userDetailsService(UserDetailsService) or see its javadoc for alternative approaches.");
        }
        return this.userDetailsService;
    }

    private String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }
}

