/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.data.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.data.spel.spi.EvaluationContextExtension;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.DenyAllPermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authorization.AuthorizationManagerFactory;
import org.springframework.security.authorization.DefaultAuthorizationManagerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;

public class SecurityEvaluationContextExtension
implements EvaluationContextExtension {
    private static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private @Nullable Authentication authentication;
    private AuthorizationManagerFactory<Object> authorizationManagerFactory = new DefaultAuthorizationManagerFactory();
    private PermissionEvaluator permissionEvaluator = new DenyAllPermissionEvaluator();
    private String defaultRolePrefix = "ROLE_";

    public SecurityEvaluationContextExtension() {
    }

    public SecurityEvaluationContextExtension(@Nullable Authentication authentication) {
        this.authentication = authentication;
    }

    public String getExtensionId() {
        return "security";
    }

    public SecurityExpressionRoot<Object> getRootObject() {
        Authentication authentication = this.getAuthentication();
        SecurityExpressionRoot<Object> root = new SecurityExpressionRoot<Object>(() -> authentication, new Object()){};
        root.setAuthorizationManagerFactory(this.authorizationManagerFactory);
        root.setPermissionEvaluator(this.permissionEvaluator);
        if (!DEFAULT_ROLE_PREFIX.equals(this.defaultRolePrefix)) {
            root.setDefaultRolePrefix(this.defaultRolePrefix);
        }
        return root;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    private @Nullable Authentication getAuthentication() {
        if (this.authentication != null) {
            return this.authentication;
        }
        SecurityContext context = this.securityContextHolderStrategy.getContext();
        return context.getAuthentication();
    }

    public void setAuthorizationManagerFactory(AuthorizationManagerFactory<Object> authorizationManagerFactory) {
        Assert.notNull(authorizationManagerFactory, (String)"authorizationManagerFactory cannot be null");
        this.authorizationManagerFactory = authorizationManagerFactory;
    }

    private DefaultAuthorizationManagerFactory<Object> getDefaultAuthorizationManagerFactory() {
        AuthorizationManagerFactory<Object> authorizationManagerFactory = this.authorizationManagerFactory;
        if (!(authorizationManagerFactory instanceof DefaultAuthorizationManagerFactory)) {
            throw new IllegalStateException("authorizationManagerFactory must be an instance of DefaultAuthorizationManagerFactory");
        }
        DefaultAuthorizationManagerFactory defaultAuthorizationManagerFactory = (DefaultAuthorizationManagerFactory)authorizationManagerFactory;
        return defaultAuthorizationManagerFactory;
    }

    @Deprecated(since="7.0")
    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, (String)"trustResolver cannot be null");
        this.getDefaultAuthorizationManagerFactory().setTrustResolver(trustResolver);
    }

    @Deprecated(since="7.0")
    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        Assert.notNull((Object)roleHierarchy, (String)"roleHierarchy cannot be null");
        this.getDefaultAuthorizationManagerFactory().setRoleHierarchy(roleHierarchy);
    }

    public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
        Assert.notNull((Object)permissionEvaluator, (String)"permissionEvaluator cannot be null");
        this.permissionEvaluator = permissionEvaluator;
    }

    @Deprecated(since="7.0")
    public void setDefaultRolePrefix(String defaultRolePrefix) {
        this.getDefaultAuthorizationManagerFactory().setRolePrefix(defaultRolePrefix);
        this.defaultRolePrefix = defaultRolePrefix;
    }
}

