/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.Ordered;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authorization.method.AuthorizationAdvisorProxyFactory;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

@Configuration
class AuthorizationProxyWebConfiguration
implements WebMvcConfigurer {
    AuthorizationProxyWebConfiguration() {
    }

    @Bean
    @Role(value=2)
    AuthorizationAdvisorProxyFactory.TargetVisitor webTargetVisitor() {
        return new WebTargetVisitor();
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
        for (int i = 0; i < resolvers.size(); ++i) {
            HandlerExceptionResolver resolver = resolvers.get(i);
            if (!(resolver instanceof DefaultHandlerExceptionResolver)) continue;
            resolvers.add(i, new AccessDeniedExceptionResolver());
            return;
        }
        resolvers.add(new AccessDeniedExceptionResolver());
    }

    static class WebTargetVisitor
    implements AuthorizationAdvisorProxyFactory.TargetVisitor,
    Ordered {
        private static final int DEFAULT_ORDER = 100;

        WebTargetVisitor() {
        }

        public Object visit(AuthorizationAdvisorProxyFactory proxyFactory, Object target) {
            if (target instanceof ResponseEntity) {
                ResponseEntity entity = (ResponseEntity)target;
                return new ResponseEntity(proxyFactory.proxy(entity.getBody()), entity.getHeaders(), entity.getStatusCode());
            }
            if (target instanceof HttpEntity) {
                HttpEntity entity = (HttpEntity)target;
                return new HttpEntity(proxyFactory.proxy(entity.getBody()), entity.getHeaders());
            }
            if (target instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)target;
                View view = mav.getView();
                String viewName = mav.getViewName();
                Map model = (Map)proxyFactory.proxy((Object)mav.getModel());
                ModelAndView proxied = view != null ? new ModelAndView(view, model) : new ModelAndView(viewName, model);
                proxied.setStatus(mav.getStatus());
                return proxied;
            }
            return null;
        }

        public int getOrder() {
            return 100;
        }
    }

    static class AccessDeniedExceptionResolver
    implements HandlerExceptionResolver {
        final ThrowableAnalyzer throwableAnalyzer = new ThrowableAnalyzer();

        AccessDeniedExceptionResolver() {
        }

        public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
            Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
            Throwable accessDeniedException = this.throwableAnalyzer.getFirstThrowableOfType(AccessDeniedException.class, causeChain);
            if (accessDeniedException != null) {
                throw (AccessDeniedException)accessDeniedException;
            }
            return null;
        }
    }
}

