/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.resource;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.DPoPAuthenticationConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.SpringOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.access.BearerTokenAccessDeniedHandler;
import org.springframework.security.oauth2.server.resource.web.authentication.BearerTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.web.authentication.BearerTokenAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.csrf.CsrfException;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public final class OAuth2ResourceServerConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<OAuth2ResourceServerConfigurer<H>, H> {
    private static final RequestHeaderRequestMatcher X_REQUESTED_WITH = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");
    private final ApplicationContext context;
    private final DPoPAuthenticationConfigurer<H> dPoPAuthenticationConfigurer = new DPoPAuthenticationConfigurer();
    private AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver;
    private AuthenticationConverter authenticationConverter;
    private JwtConfigurer jwtConfigurer;
    private OpaqueTokenConfigurer opaqueTokenConfigurer;
    private AccessDeniedHandler accessDeniedHandler = new DelegatingAccessDeniedHandler(new LinkedHashMap<Class<CsrfException>, AccessDeniedHandlerImpl>(Map.of(CsrfException.class, new AccessDeniedHandlerImpl())), (AccessDeniedHandler)new BearerTokenAccessDeniedHandler());
    private AuthenticationEntryPoint authenticationEntryPoint = new BearerTokenAuthenticationEntryPoint();
    private BearerTokenRequestMatcher requestMatcher = new BearerTokenRequestMatcher();

    public OAuth2ResourceServerConfigurer(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        this.context = context;
    }

    public OAuth2ResourceServerConfigurer<H> accessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        Assert.notNull((Object)accessDeniedHandler, (String)"accessDeniedHandler cannot be null");
        this.accessDeniedHandler = accessDeniedHandler;
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> authenticationEntryPoint(AuthenticationEntryPoint entryPoint) {
        Assert.notNull((Object)entryPoint, (String)"entryPoint cannot be null");
        this.authenticationEntryPoint = entryPoint;
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> authenticationManagerResolver(AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver) {
        Assert.notNull(authenticationManagerResolver, (String)"authenticationManagerResolver cannot be null");
        this.authenticationManagerResolver = authenticationManagerResolver;
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> bearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        Assert.notNull((Object)bearerTokenResolver, (String)"bearerTokenResolver cannot be null");
        this.authenticationConverter = new BearerTokenResolverHoldingAuthenticationConverter(bearerTokenResolver);
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> authenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> jwt(Customizer<JwtConfigurer> jwtCustomizer) {
        if (this.jwtConfigurer == null) {
            this.jwtConfigurer = new JwtConfigurer(this.context);
        }
        jwtCustomizer.customize(this.jwtConfigurer);
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> opaqueToken(Customizer<OpaqueTokenConfigurer> opaqueTokenCustomizer) {
        if (this.opaqueTokenConfigurer == null) {
            this.opaqueTokenConfigurer = new OpaqueTokenConfigurer(this.context);
        }
        opaqueTokenCustomizer.customize(this.opaqueTokenConfigurer);
        return this;
    }

    @Override
    public void init(H http) {
        this.validateConfiguration();
        this.registerDefaultAccessDeniedHandler(http);
        this.registerDefaultEntryPoint(http);
        this.registerDefaultCsrfOverride(http);
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider();
        if (authenticationProvider != null) {
            http.authenticationProvider(authenticationProvider);
        }
    }

    @Override
    public void configure(H http) {
        AuthenticationManagerResolver resolver = this.authenticationManagerResolver;
        if (resolver == null) {
            AuthenticationManager authenticationManager = this.getAuthenticationManager(http);
            resolver = request -> authenticationManager;
        }
        AuthenticationConverter converter = this.getAuthenticationConverter();
        this.requestMatcher.setAuthenticationConverter(converter);
        BearerTokenAuthenticationFilter filter = new BearerTokenAuthenticationFilter(resolver, converter);
        filter.setAuthenticationEntryPoint(this.authenticationEntryPoint);
        filter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        filter = this.postProcess(filter);
        http.addFilter((Filter)filter);
        this.dPoPAuthenticationConfigurer.configure(http);
    }

    private void validateConfiguration() {
        if (this.authenticationManagerResolver == null) {
            Assert.state((this.jwtConfigurer != null || this.opaqueTokenConfigurer != null ? 1 : 0) != 0, (String)"Jwt and Opaque Token are the only supported formats for bearer tokens in Spring Security and neither was found. Make sure to configure JWT via http.oauth2ResourceServer().jwt() or Opaque Tokens via http.oauth2ResourceServer().opaqueToken().");
            Assert.state((this.jwtConfigurer == null || this.opaqueTokenConfigurer == null ? 1 : 0) != 0, (String)"Spring Security only supports JWTs or Opaque Tokens, not both at the same time.");
        } else {
            Assert.state((this.jwtConfigurer == null && this.opaqueTokenConfigurer == null ? 1 : 0) != 0, (String)"If an authenticationManagerResolver() is configured, then it takes precedence over any jwt() or opaqueToken() configuration.");
        }
    }

    private void registerDefaultAccessDeniedHandler(H http) {
        ExceptionHandlingConfigurer exceptionHandling = http.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            exceptionHandling.defaultAccessDeniedHandlerFor(this.accessDeniedHandler, this.requestMatcher);
        }
    }

    private void registerDefaultEntryPoint(H http) {
        ExceptionHandlingConfigurer exceptionHandling = http.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            ContentNegotiationStrategy contentNegotiationStrategy = http.getSharedObject(ContentNegotiationStrategy.class);
            if (contentNegotiationStrategy == null) {
                contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
            }
            MediaTypeRequestMatcher restMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML});
            restMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            MediaTypeRequestMatcher allMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.ALL});
            allMatcher.setUseEquals(true);
            NegatedRequestMatcher notHtmlMatcher = new NegatedRequestMatcher((RequestMatcher)new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.TEXT_HTML}));
            AndRequestMatcher restNotHtmlMatcher = new AndRequestMatcher(Arrays.asList(notHtmlMatcher, restMatcher));
            OrRequestMatcher preferredMatcher = new OrRequestMatcher(Arrays.asList(this.requestMatcher, X_REQUESTED_WITH, restNotHtmlMatcher, allMatcher));
            exceptionHandling.defaultAuthenticationEntryPointFor(this.authenticationEntryPoint, (RequestMatcher)preferredMatcher);
        }
    }

    private void registerDefaultCsrfOverride(H http) {
        CsrfConfigurer csrf = http.getConfigurer(CsrfConfigurer.class);
        if (csrf != null) {
            csrf.ignoringRequestMatchers(this.requestMatcher);
        }
    }

    AuthenticationProvider getAuthenticationProvider() {
        if (this.jwtConfigurer != null) {
            return this.jwtConfigurer.getAuthenticationProvider();
        }
        if (this.opaqueTokenConfigurer != null) {
            return this.opaqueTokenConfigurer.getAuthenticationProvider();
        }
        return null;
    }

    AuthenticationManager getAuthenticationManager(H http) {
        if (this.jwtConfigurer != null) {
            return this.jwtConfigurer.getAuthenticationManager(http);
        }
        if (this.opaqueTokenConfigurer != null) {
            return this.opaqueTokenConfigurer.getAuthenticationManager(http);
        }
        return http.getSharedObject(AuthenticationManager.class);
    }

    AuthenticationManagerResolver<HttpServletRequest> getAuthenticationManagerResolver() {
        return this.authenticationManagerResolver;
    }

    AuthenticationConverter getAuthenticationConverter() {
        if (this.authenticationConverter != null) {
            return this.authenticationConverter;
        }
        if (this.context.getBeanNamesForType(AuthenticationConverter.class).length > 0) {
            this.authenticationConverter = (AuthenticationConverter)this.context.getBean(AuthenticationConverter.class);
        } else if (this.context.getBeanNamesForType(BearerTokenResolver.class).length > 0) {
            BearerTokenResolver bearerTokenResolver = (BearerTokenResolver)this.context.getBean(BearerTokenResolver.class);
            this.authenticationConverter = new BearerTokenResolverHoldingAuthenticationConverter(bearerTokenResolver);
        } else {
            this.authenticationConverter = new BearerTokenAuthenticationConverter();
        }
        return this.authenticationConverter;
    }

    BearerTokenResolver getBearerTokenResolver() {
        AuthenticationConverter authenticationConverter = this.getAuthenticationConverter();
        if (authenticationConverter instanceof BearerTokenResolverHoldingAuthenticationConverter) {
            BearerTokenResolverHoldingAuthenticationConverter bearer = (BearerTokenResolverHoldingAuthenticationConverter)authenticationConverter;
            return bearer.bearerTokenResolver;
        }
        return null;
    }

    private static final class BearerTokenRequestMatcher
    implements RequestMatcher {
        private AuthenticationConverter authenticationConverter;

        private BearerTokenRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            try {
                return this.authenticationConverter.convert(request) != null;
            }
            catch (OAuth2AuthenticationException ex) {
                return false;
            }
        }

        void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
            Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
            this.authenticationConverter = authenticationConverter;
        }
    }

    private static final class BearerTokenResolverHoldingAuthenticationConverter
    implements AuthenticationConverter {
        private final BearerTokenResolver bearerTokenResolver;
        private final AuthenticationConverter authenticationConverter;

        BearerTokenResolverHoldingAuthenticationConverter(BearerTokenResolver bearerTokenResolver) {
            this.bearerTokenResolver = bearerTokenResolver;
            BearerTokenAuthenticationConverter authenticationConverter = new BearerTokenAuthenticationConverter();
            authenticationConverter.setBearerTokenResolver(bearerTokenResolver);
            this.authenticationConverter = authenticationConverter;
        }

        public Authentication convert(HttpServletRequest request) {
            return this.authenticationConverter.convert(request);
        }
    }

    public class JwtConfigurer {
        private final ApplicationContext context;
        private AuthenticationManager authenticationManager;
        private JwtDecoder decoder;
        private Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter;

        JwtConfigurer(ApplicationContext context) {
            this.context = context;
        }

        public JwtConfigurer authenticationManager(AuthenticationManager authenticationManager) {
            Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
            this.authenticationManager = authenticationManager;
            return this;
        }

        public JwtConfigurer decoder(JwtDecoder decoder) {
            this.decoder = decoder;
            return this;
        }

        public JwtConfigurer jwkSetUri(String uri) {
            this.decoder = NimbusJwtDecoder.withJwkSetUri((String)uri).build();
            return this;
        }

        public JwtConfigurer jwtAuthenticationConverter(Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter) {
            this.jwtAuthenticationConverter = jwtAuthenticationConverter;
            return this;
        }

        Converter<Jwt, ? extends AbstractAuthenticationToken> getJwtAuthenticationConverter() {
            if (this.jwtAuthenticationConverter == null) {
                this.jwtAuthenticationConverter = this.context.getBeanNamesForType(JwtAuthenticationConverter.class).length > 0 ? (Converter)this.context.getBean(JwtAuthenticationConverter.class) : new JwtAuthenticationConverter();
            }
            return this.jwtAuthenticationConverter;
        }

        JwtDecoder getJwtDecoder() {
            if (this.decoder == null) {
                return (JwtDecoder)this.context.getBean(JwtDecoder.class);
            }
            return this.decoder;
        }

        AuthenticationProvider getAuthenticationProvider() {
            if (this.authenticationManager != null) {
                return null;
            }
            JwtDecoder decoder = this.getJwtDecoder();
            Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter = this.getJwtAuthenticationConverter();
            JwtAuthenticationProvider provider = new JwtAuthenticationProvider(decoder);
            provider.setJwtAuthenticationConverter(jwtAuthenticationConverter);
            return (AuthenticationProvider)OAuth2ResourceServerConfigurer.this.postProcess(provider);
        }

        AuthenticationManager getAuthenticationManager(H http) {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            return http.getSharedObject(AuthenticationManager.class);
        }
    }

    public class OpaqueTokenConfigurer {
        private final ApplicationContext context;
        private AuthenticationManager authenticationManager;
        private String introspectionUri;
        private String clientId;
        private String clientSecret;
        private Supplier<OpaqueTokenIntrospector> introspector;
        private OpaqueTokenAuthenticationConverter authenticationConverter;

        OpaqueTokenConfigurer(ApplicationContext context) {
            this.context = context;
        }

        public OpaqueTokenConfigurer authenticationManager(AuthenticationManager authenticationManager) {
            Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
            this.authenticationManager = authenticationManager;
            return this;
        }

        public OpaqueTokenConfigurer introspectionUri(String introspectionUri) {
            Assert.notNull((Object)introspectionUri, (String)"introspectionUri cannot be null");
            this.introspectionUri = introspectionUri;
            this.introspector = () -> new SpringOpaqueTokenIntrospector(this.introspectionUri, this.clientId, this.clientSecret);
            return this;
        }

        public OpaqueTokenConfigurer introspectionClientCredentials(String clientId, String clientSecret) {
            Assert.notNull((Object)clientId, (String)"clientId cannot be null");
            Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.introspector = () -> new SpringOpaqueTokenIntrospector(this.introspectionUri, this.clientId, this.clientSecret);
            return this;
        }

        public OpaqueTokenConfigurer introspector(OpaqueTokenIntrospector introspector) {
            Assert.notNull((Object)introspector, (String)"introspector cannot be null");
            this.introspector = () -> introspector;
            return this;
        }

        public OpaqueTokenConfigurer authenticationConverter(OpaqueTokenAuthenticationConverter authenticationConverter) {
            Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
            this.authenticationConverter = authenticationConverter;
            return this;
        }

        OpaqueTokenIntrospector getIntrospector() {
            if (this.introspector != null) {
                return this.introspector.get();
            }
            return (OpaqueTokenIntrospector)this.context.getBean(OpaqueTokenIntrospector.class);
        }

        OpaqueTokenAuthenticationConverter getAuthenticationConverter() {
            if (this.authenticationConverter != null) {
                return this.authenticationConverter;
            }
            if (this.context.getBeanNamesForType(OpaqueTokenAuthenticationConverter.class).length > 0) {
                return (OpaqueTokenAuthenticationConverter)this.context.getBean(OpaqueTokenAuthenticationConverter.class);
            }
            return null;
        }

        AuthenticationProvider getAuthenticationProvider() {
            if (this.authenticationManager != null) {
                return null;
            }
            OpaqueTokenIntrospector introspector = this.getIntrospector();
            OpaqueTokenAuthenticationProvider opaqueTokenAuthenticationProvider = new OpaqueTokenAuthenticationProvider(introspector);
            OpaqueTokenAuthenticationConverter authenticationConverter = this.getAuthenticationConverter();
            if (authenticationConverter != null) {
                opaqueTokenAuthenticationProvider.setAuthenticationConverter(authenticationConverter);
            }
            return opaqueTokenAuthenticationProvider;
        }

        AuthenticationManager getAuthenticationManager(H http) {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            return http.getSharedObject(AuthenticationManager.class);
        }
    }
}

