/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.DeferringObservationAuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class Jsr250MethodSecurityConfiguration
implements ImportAware,
AopInfrastructureBean {
    private int interceptorOrderOffset;

    Jsr250MethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor jsr250AuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<AuthorizationEventPublisher> eventPublisherProvider, ObjectProvider<ObservationRegistry> registryProvider, ObjectProvider<RoleHierarchy> roleHierarchyProvider, Jsr250MethodSecurityConfiguration configuration) {
        Jsr250AuthorizationManager jsr250 = new Jsr250AuthorizationManager();
        AuthoritiesAuthorizationManager authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
        RoleHierarchy roleHierarchy = (RoleHierarchy)roleHierarchyProvider.getIfAvailable(NullRoleHierarchy::new);
        authoritiesAuthorizationManager.setRoleHierarchy(roleHierarchy);
        jsr250.setAuthoritiesAuthorizationManager((AuthorizationManager)authoritiesAuthorizationManager);
        defaultsProvider.ifAvailable(d -> jsr250.setRolePrefix(d.getRolePrefix()));
        SecurityContextHolderStrategy strategy = (SecurityContextHolderStrategy)strategyProvider.getIfAvailable(SecurityContextHolder::getContextHolderStrategy);
        DeferringObservationAuthorizationManager manager = new DeferringObservationAuthorizationManager(registryProvider, jsr250);
        AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.jsr250(manager);
        interceptor.setOrder(interceptor.getOrder() + configuration.interceptorOrderOffset);
        interceptor.setSecurityContextHolderStrategy(strategy);
        eventPublisherProvider.ifAvailable(arg_0 -> ((AuthorizationManagerBeforeMethodInterceptor)interceptor).setAuthorizationEventPublisher(arg_0));
        return interceptor;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        EnableMethodSecurity annotation = (EnableMethodSecurity)importMetadata.getAnnotations().get(EnableMethodSecurity.class).synthesize();
        this.interceptorOrderOffset = annotation.offset();
    }
}

