/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MethodSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_USE_JSR250 = "jsr250-enabled";
    private static final String ATT_USE_SECURED = "secured-enabled";
    private static final String ATT_USE_PREPOST = "pre-post-enabled";
    private static final String ATT_REF = "ref";

    public BeanDefinition parse(Element element, ParserContext pc) {
        boolean jsr250Enabled;
        boolean securedEnabled;
        boolean prePostAnnotationsEnabled;
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        boolean bl = prePostAnnotationsEnabled = !element.hasAttribute(ATT_USE_PREPOST) || "true".equals(element.getAttribute(ATT_USE_PREPOST));
        if (prePostAnnotationsEnabled) {
            BeanDefinitionBuilder preFilterInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PreFilterAuthorizationMethodInterceptor.class).setRole(2);
            BeanDefinitionBuilder preAuthorizeInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PreAuthorizeAuthorizationMethodInterceptor.class).setRole(2);
            BeanDefinitionBuilder postAuthorizeInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PostAuthorizeAuthorizationMethodInterceptor.class).setRole(2);
            BeanDefinitionBuilder postFilterInterceptor = BeanDefinitionBuilder.rootBeanDefinition(PostFilterAuthorizationMethodInterceptor.class).setRole(2);
            Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
            if (expressionHandlerElt != null) {
                String expressionHandlerRef = expressionHandlerElt.getAttribute(ATT_REF);
                preFilterInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
                preAuthorizeInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
                postAuthorizeInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
                postFilterInterceptor.addPropertyReference("expressionHandler", expressionHandlerRef);
            } else {
                AbstractBeanDefinition expressionHandler = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityExpressionHandlerBean.class).getBeanDefinition();
                preFilterInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
                preAuthorizeInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
                postAuthorizeInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
                postFilterInterceptor.addPropertyValue("expressionHandler", (Object)expressionHandler);
            }
            pc.getRegistry().registerBeanDefinition("preFilterAuthorizationMethodInterceptor", (BeanDefinition)preFilterInterceptor.getBeanDefinition());
            pc.getRegistry().registerBeanDefinition("preAuthorizeAuthorizationMethodInterceptor", (BeanDefinition)preAuthorizeInterceptor.getBeanDefinition());
            pc.getRegistry().registerBeanDefinition("postAuthorizeAuthorizationMethodInterceptor", (BeanDefinition)postAuthorizeInterceptor.getBeanDefinition());
            pc.getRegistry().registerBeanDefinition("postFilterAuthorizationMethodInterceptor", (BeanDefinition)postFilterInterceptor.getBeanDefinition());
        }
        if (securedEnabled = "true".equals(element.getAttribute(ATT_USE_SECURED))) {
            BeanDefinitionBuilder securedInterceptor = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationManagerBeforeMethodInterceptor.class).setRole(2).setFactoryMethod("secured");
            pc.getRegistry().registerBeanDefinition("securedAuthorizationMethodInterceptor", (BeanDefinition)securedInterceptor.getBeanDefinition());
        }
        if (jsr250Enabled = "true".equals(element.getAttribute(ATT_USE_JSR250))) {
            BeanDefinitionBuilder jsr250Interceptor = BeanDefinitionBuilder.rootBeanDefinition(Jsr250AuthorizationMethodInterceptor.class).setRole(2);
            pc.getRegistry().registerBeanDefinition("jsr250AuthorizationMethodInterceptor", (BeanDefinition)jsr250Interceptor.getBeanDefinition());
        }
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)pc, (Element)element);
        pc.popAndRegisterContainingComponent();
        return null;
    }

    public static final class PreAuthorizeAuthorizationMethodInterceptor
    implements FactoryBean<AuthorizationManagerBeforeMethodInterceptor> {
        private final PreAuthorizeAuthorizationManager manager = new PreAuthorizeAuthorizationManager();

        public AuthorizationManagerBeforeMethodInterceptor getObject() {
            return AuthorizationManagerBeforeMethodInterceptor.preAuthorize((PreAuthorizeAuthorizationManager)this.manager);
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerBeforeMethodInterceptor.class;
        }

        public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
            this.manager.setExpressionHandler(expressionHandler);
        }
    }

    public static final class PostAuthorizeAuthorizationMethodInterceptor
    implements FactoryBean<AuthorizationManagerAfterMethodInterceptor> {
        private final PostAuthorizeAuthorizationManager manager = new PostAuthorizeAuthorizationManager();

        public AuthorizationManagerAfterMethodInterceptor getObject() {
            return AuthorizationManagerAfterMethodInterceptor.postAuthorize((PostAuthorizeAuthorizationManager)this.manager);
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerAfterMethodInterceptor.class;
        }

        public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
            this.manager.setExpressionHandler(expressionHandler);
        }
    }

    public static final class MethodSecurityExpressionHandlerBean
    implements FactoryBean<MethodSecurityExpressionHandler>,
    ApplicationContextAware {
        private final DefaultMethodSecurityExpressionHandler expressionHandler = new DefaultMethodSecurityExpressionHandler();

        public MethodSecurityExpressionHandler getObject() {
            return this.expressionHandler;
        }

        public Class<?> getObjectType() {
            return MethodSecurityExpressionHandler.class;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            String[] grantedAuthorityDefaultsBeanNames = applicationContext.getBeanNamesForType(GrantedAuthorityDefaults.class);
            if (grantedAuthorityDefaultsBeanNames.length == 1) {
                GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)applicationContext.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
                this.expressionHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
            }
        }
    }

    public static final class Jsr250AuthorizationMethodInterceptor
    implements FactoryBean<AuthorizationManagerBeforeMethodInterceptor>,
    ApplicationContextAware {
        private final Jsr250AuthorizationManager manager = new Jsr250AuthorizationManager();

        public AuthorizationManagerBeforeMethodInterceptor getObject() {
            return AuthorizationManagerBeforeMethodInterceptor.jsr250((Jsr250AuthorizationManager)this.manager);
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerBeforeMethodInterceptor.class;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            String[] grantedAuthorityDefaultsBeanNames = applicationContext.getBeanNamesForType(GrantedAuthorityDefaults.class);
            if (grantedAuthorityDefaultsBeanNames.length == 1) {
                GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)applicationContext.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
                this.manager.setRolePrefix(grantedAuthorityDefaults.getRolePrefix());
            }
        }
    }
}

