/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.List;
import org.springframework.aop.config.AbstractInterceptorDrivenBeanDefinitionDecorator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.security.config.method.MethodConfigUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InterceptMethodsBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private final BeanDefinitionDecorator delegate = new InternalInterceptMethodsBeanDefinitionDecorator();

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        MethodConfigUtils.registerDefaultMethodAccessManagerIfNecessary(parserContext);
        return this.delegate.decorate(node, definition, parserContext);
    }

    static class InternalInterceptMethodsBeanDefinitionDecorator
    extends AbstractInterceptorDrivenBeanDefinitionDecorator {
        static final String ATT_METHOD = "method";
        static final String ATT_ACCESS = "access";
        private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";

        InternalInterceptMethodsBeanDefinitionDecorator() {
        }

        protected BeanDefinition createInterceptorDefinition(Node node) {
            Element interceptMethodsElt = (Element)node;
            BeanDefinitionBuilder interceptor = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityInterceptor.class);
            interceptor.setAutowireMode(2);
            String accessManagerId = interceptMethodsElt.getAttribute(ATT_ACCESS_MGR);
            if (!StringUtils.hasText((String)accessManagerId)) {
                accessManagerId = "org.springframework.security.defaultMethodAccessManager";
            }
            interceptor.addPropertyValue("accessDecisionManager", (Object)new RuntimeBeanReference(accessManagerId));
            interceptor.addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("org.springframework.security.authenticationManager"));
            String parentBeanClass = ((Element)node.getParentNode()).getAttribute("class");
            List methods = DomUtils.getChildElementsByTagName((Element)interceptMethodsElt, (String)"protect");
            ManagedMap mappings = new ManagedMap();
            for (Element protectmethodElt : methods) {
                BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
                attributeBuilder.setFactoryMethod("createListFromCommaDelimitedString");
                attributeBuilder.addConstructorArgValue((Object)protectmethodElt.getAttribute(ATT_ACCESS));
                Object methodName = protectmethodElt.getAttribute(ATT_METHOD);
                if (((String)methodName).lastIndexOf(".") == -1 && parentBeanClass != null && !"".equals(parentBeanClass)) {
                    methodName = parentBeanClass + "." + (String)methodName;
                }
                mappings.put(methodName, attributeBuilder.getBeanDefinition());
            }
            RootBeanDefinition metadataSource = new RootBeanDefinition(MapBasedMethodSecurityMetadataSource.class);
            metadataSource.getConstructorArgumentValues().addGenericArgumentValue((Object)mappings);
            interceptor.addPropertyValue("securityMetadataSource", (Object)metadataSource);
            return interceptor.getBeanDefinition();
        }
    }
}

