/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthenticationManagerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_ALIAS = "alias";
    private static final String ATT_REF = "ref";
    private static final String ATT_ERASE_CREDENTIALS = "erase-credentials";
    private static final String AUTHENTICATION_EVENT_PUBLISHER_BEAN_NAME = "defaultAuthenticationEventPublisher";

    public BeanDefinition parse(Element element, ParserContext pc) {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            if (pc.getRegistry().containsBeanDefinition("org.springframework.security.authenticationManager")) {
                pc.getReaderContext().warning("Overriding globally registered AuthenticationManager", pc.extractSource((Object)element));
            }
            id = "org.springframework.security.authenticationManager";
        }
        pc.pushContainingComponent(new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element)));
        BeanDefinitionBuilder providerManagerBldr = BeanDefinitionBuilder.rootBeanDefinition(ProviderManager.class);
        String alias = element.getAttribute(ATT_ALIAS);
        ManagedList providers = new ManagedList();
        NamespaceHandlerResolver resolver = pc.getReaderContext().getNamespaceHandlerResolver();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            providers.add(this.extracted(element, pc, resolver, (Element)node));
        }
        if (providers.isEmpty()) {
            providers.add(new RootBeanDefinition(NullAuthenticationProvider.class));
        }
        providerManagerBldr.addConstructorArgValue((Object)providers);
        if ("false".equals(element.getAttribute(ATT_ERASE_CREDENTIALS))) {
            providerManagerBldr.addPropertyValue("eraseCredentialsAfterAuthentication", (Object)false);
        }
        if (!pc.getRegistry().containsBeanDefinition(AUTHENTICATION_EVENT_PUBLISHER_BEAN_NAME)) {
            RootBeanDefinition publisher = new RootBeanDefinition(DefaultAuthenticationEventPublisher.class);
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)publisher, AUTHENTICATION_EVENT_PUBLISHER_BEAN_NAME));
        }
        providerManagerBldr.addPropertyReference("authenticationEventPublisher", AUTHENTICATION_EVENT_PUBLISHER_BEAN_NAME);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)providerManagerBldr.getBeanDefinition(), id));
        if (StringUtils.hasText((String)alias)) {
            pc.getRegistry().registerAlias(id, alias);
            pc.getReaderContext().fireAliasRegistered(id, alias, pc.extractSource((Object)element));
        }
        if (!"org.springframework.security.authenticationManager".equals(id)) {
            pc.getRegistry().registerAlias(id, "org.springframework.security.authenticationManager");
            pc.getReaderContext().fireAliasRegistered(id, "org.springframework.security.authenticationManager", pc.extractSource((Object)element));
        }
        pc.popAndRegisterContainingComponent();
        return null;
    }

    private BeanMetadataElement extracted(Element element, ParserContext pc, NamespaceHandlerResolver resolver, Element providerElement) {
        String ref = providerElement.getAttribute(ATT_REF);
        if (!StringUtils.hasText((String)ref)) {
            BeanDefinition provider = resolver.resolve(providerElement.getNamespaceURI()).parse(providerElement, pc);
            Assert.notNull((Object)provider, () -> "Parser for " + providerElement.getNodeName() + " returned a null bean definition");
            String providerId = pc.getReaderContext().generateBeanName(provider);
            pc.registerBeanComponent(new BeanComponentDefinition(provider, providerId));
            return new RuntimeBeanReference(providerId);
        }
        if (providerElement.getAttributes().getLength() > 1) {
            pc.getReaderContext().error("authentication-provider element cannot be used with other attributes when using 'ref' attribute", pc.extractSource((Object)element));
        }
        NodeList providerChildren = providerElement.getChildNodes();
        for (int i = 0; i < providerChildren.getLength(); ++i) {
            if (!(providerChildren.item(i) instanceof Element)) continue;
            pc.getReaderContext().error("authentication-provider element cannot have child elements when used with 'ref' attribute", pc.extractSource((Object)element));
        }
        return new RuntimeBeanReference(ref);
    }

    public static final class NullAuthenticationProvider
    implements AuthenticationProvider {
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            return null;
        }

        public boolean supports(Class<?> authentication) {
            return false;
        }
    }
}

