/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;

public final class ServletApiConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<ServletApiConfigurer<H>, H> {
    private SecurityContextHolderAwareRequestFilter securityContextRequestFilter = new SecurityContextHolderAwareRequestFilter();

    public ServletApiConfigurer<H> rolePrefix(String rolePrefix) {
        this.securityContextRequestFilter.setRolePrefix(rolePrefix);
        return this;
    }

    @Override
    public void configure(H http) {
        String[] grantedAuthorityDefaultsBeanNames;
        ApplicationContext context;
        this.securityContextRequestFilter.setAuthenticationManager(http.getSharedObject(AuthenticationManager.class));
        ExceptionHandlingConfigurer exceptionConf = http.getConfigurer(ExceptionHandlingConfigurer.class);
        AuthenticationEntryPoint authenticationEntryPoint = exceptionConf != null ? exceptionConf.getAuthenticationEntryPoint(http) : null;
        this.securityContextRequestFilter.setAuthenticationEntryPoint(authenticationEntryPoint);
        LogoutConfigurer logoutConf = http.getConfigurer(LogoutConfigurer.class);
        List<LogoutHandler> logoutHandlers = logoutConf != null ? logoutConf.getLogoutHandlers() : null;
        this.securityContextRequestFilter.setLogoutHandlers(logoutHandlers);
        AuthenticationTrustResolver trustResolver = http.getSharedObject(AuthenticationTrustResolver.class);
        if (trustResolver != null) {
            this.securityContextRequestFilter.setTrustResolver(trustResolver);
        }
        if ((context = http.getSharedObject(ApplicationContext.class)) != null && (grantedAuthorityDefaultsBeanNames = context.getBeanNamesForType(GrantedAuthorityDefaults.class)).length == 1) {
            GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)context.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
            this.securityContextRequestFilter.setRolePrefix(grantedAuthorityDefaults.getRolePrefix());
        }
        this.securityContextRequestFilter = this.postProcess(this.securityContextRequestFilter);
        http.addFilter((Filter)this.securityContextRequestFilter);
    }
}

