/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import jakarta.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.DispatcherTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class AbstractRequestMatcherRegistry<C> {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private static final RequestMatcher ANY_REQUEST = AnyRequestMatcher.INSTANCE;
    private ApplicationContext context;
    private boolean anyRequestConfigured = false;

    protected final void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.context;
    }

    public C anyRequest() {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure anyRequest after itself");
        C configurer = this.requestMatchers(ANY_REQUEST);
        this.anyRequestConfigured = true;
        return configurer;
    }

    public C antMatchers(HttpMethod method) {
        return this.antMatchers(method, "/**");
    }

    public C antMatchers(HttpMethod method, String ... antPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure antMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.antMatchers(method, antPatterns));
    }

    public C antMatchers(String ... antPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure antMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.antMatchers(antPatterns));
    }

    public abstract C mvcMatchers(String ... var1);

    public abstract C mvcMatchers(HttpMethod var1, String ... var2);

    protected final List<MvcRequestMatcher> createMvcMatchers(HttpMethod method, String ... mvcPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure mvcMatchers after anyRequest");
        ObjectPostProcessor opp = (ObjectPostProcessor)this.context.getBean(ObjectPostProcessor.class);
        if (!this.context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            throw new NoSuchBeanDefinitionException("A Bean named mvcHandlerMappingIntrospector of type " + HandlerMappingIntrospector.class.getName() + " is required to use MvcRequestMatcher. Please ensure Spring Security & Spring MVC are configured in a shared ApplicationContext.");
        }
        HandlerMappingIntrospector introspector = (HandlerMappingIntrospector)this.context.getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, HandlerMappingIntrospector.class);
        ArrayList<MvcRequestMatcher> matchers = new ArrayList<MvcRequestMatcher>(mvcPatterns.length);
        for (String mvcPattern : mvcPatterns) {
            MvcRequestMatcher matcher = new MvcRequestMatcher(introspector, mvcPattern);
            opp.postProcess(matcher);
            if (method != null) {
                matcher.setMethod(method);
            }
            matchers.add(matcher);
        }
        return matchers;
    }

    public C regexMatchers(HttpMethod method, String ... regexPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure regexMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(method, regexPatterns));
    }

    public C regexMatchers(String ... regexPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure regexMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(regexPatterns));
    }

    public C dispatcherTypeMatchers(@Nullable HttpMethod method, DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        for (DispatcherType dispatcherType : dispatcherTypes) {
            matchers.add((RequestMatcher)new DispatcherTypeRequestMatcher(dispatcherType, method));
        }
        return this.chainRequestMatchers(matchers);
    }

    public C dispatcherTypeMatchers(DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        return this.dispatcherTypeMatchers((HttpMethod)null, dispatcherTypes);
    }

    public C requestMatchers(RequestMatcher ... requestMatchers) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure requestMatchers after anyRequest");
        return this.chainRequestMatchers(Arrays.asList(requestMatchers));
    }

    protected abstract C chainRequestMatchers(List<RequestMatcher> var1);

    private static final class RequestMatchers {
        private RequestMatchers() {
        }

        static List<RequestMatcher> antMatchers(HttpMethod httpMethod, String ... antPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : antPatterns) {
                matchers.add((RequestMatcher)new AntPathRequestMatcher(pattern, method));
            }
            return matchers;
        }

        static List<RequestMatcher> antMatchers(String ... antPatterns) {
            return RequestMatchers.antMatchers(null, antPatterns);
        }

        static List<RequestMatcher> regexMatchers(HttpMethod httpMethod, String ... regexPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : regexPatterns) {
                matchers.add((RequestMatcher)new RegexRequestMatcher(pattern, method));
            }
            return matchers;
        }

        static List<RequestMatcher> regexMatchers(String ... regexPatterns) {
            return RequestMatchers.regexMatchers(null, regexPatterns);
        }
    }
}

