/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.web.server.AuthorizeExchangeDsl;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.config.web.server.ServerSecurityMarker;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;

@ServerSecurityMarker
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001:\u0003()*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bJ \u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u00042\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001d\u0010\u0019\u001a\u0012\u0012\b\u0012\u00060\u001bR\u00020\u001c\u0012\u0004\u0012\u00020\u00140\u001aH\u0000\u00a2\u0006\u0002\b\u001dJ%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160 \"\u00020\u0016\u00a2\u0006\u0002\u0010!J%\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160 \"\u00020\u0016\u00a2\u0006\u0002\u0010!J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010%\u001a\u00020\u0016J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010'\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006+"}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl;", "", "()V", "anyExchange", "Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "getAnyExchange", "()Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "authenticated", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "getAuthenticated", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "authorizationRules", "", "Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "denyAll", "getDenyAll", "permitAll", "getPermitAll", "authorize", "", "antPattern", "", "access", "matcher", "get", "Lkotlin/Function1;", "Lorg/springframework/security/config/web/server/ServerHttpSecurity$AuthorizeExchangeSpec;", "Lorg/springframework/security/config/web/server/ServerHttpSecurity;", "get$spring_security_config", "hasAnyAuthority", "authorities", "", "([Ljava/lang/String;)Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "hasAnyRole", "roles", "hasAuthority", "authority", "hasRole", "role", "ExchangeAuthorizationRule", "MatcherExchangeAuthorizationRule", "PatternExchangeAuthorizationRule", "spring-security-config"})
public final class AuthorizeExchangeDsl {
    private final List<ExchangeAuthorizationRule> authorizationRules;
    @NotNull
    private final ServerWebExchangeMatcher anyExchange;
    @NotNull
    private final ReactiveAuthorizationManager<AuthorizationContext> permitAll;
    @NotNull
    private final ReactiveAuthorizationManager<AuthorizationContext> denyAll;
    @NotNull
    private final ReactiveAuthorizationManager<AuthorizationContext> authenticated;

    public final void authorize(@NotNull ServerWebExchangeMatcher matcher, @NotNull ReactiveAuthorizationManager<AuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new MatcherExchangeAuthorizationRule(matcher, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeExchangeDsl authorizeExchangeDsl, ServerWebExchangeMatcher serverWebExchangeMatcher, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
        if ((n & 1) != 0) {
            ServerWebExchangeMatcher serverWebExchangeMatcher2 = ServerWebExchangeMatchers.anyExchange();
            Intrinsics.checkNotNullExpressionValue((Object)serverWebExchangeMatcher2, (String)"ServerWebExchangeMatchers.anyExchange()");
            serverWebExchangeMatcher = serverWebExchangeMatcher2;
        }
        if ((n & 2) != 0) {
            reactiveAuthorizationManager = authorizeExchangeDsl.authenticated;
        }
        authorizeExchangeDsl.authorize(serverWebExchangeMatcher, reactiveAuthorizationManager);
    }

    public final void authorize(@NotNull String antPattern, @NotNull ReactiveAuthorizationManager<AuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)antPattern, (String)"antPattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new PatternExchangeAuthorizationRule(antPattern, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeExchangeDsl authorizeExchangeDsl, String string, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
        if ((n & 2) != 0) {
            reactiveAuthorizationManager = authorizeExchangeDsl.authenticated;
        }
        authorizeExchangeDsl.authorize(string, reactiveAuthorizationManager);
    }

    @NotNull
    public final ServerWebExchangeMatcher getAnyExchange() {
        return this.anyExchange;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> getPermitAll() {
        return this.permitAll;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> getDenyAll() {
        return this.denyAll;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasRole((String)role);
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"AuthorityReactiveAuthori\u2026thorizationContext>(role)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasAnyRole(String ... roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasAnyRole((String[])Arrays.copyOf(roles, roles.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"AuthorityReactiveAuthori\u2026orizationContext>(*roles)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasAuthority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasAuthority((String)authority);
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"AuthorityReactiveAuthori\u2026zationContext>(authority)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> hasAnyAuthority(String ... authorities) {
        Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
        AuthorityReactiveAuthorizationManager authorityReactiveAuthorizationManager = AuthorityReactiveAuthorizationManager.hasAnyAuthority((String[])Arrays.copyOf(authorities, authorities.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorityReactiveAuthorizationManager, (String)"AuthorityReactiveAuthori\u2026ionContext>(*authorities)");
        return (ReactiveAuthorizationManager)authorityReactiveAuthorizationManager;
    }

    @NotNull
    public final ReactiveAuthorizationManager<AuthorizationContext> getAuthenticated() {
        return this.authenticated;
    }

    @NotNull
    public final Function1<ServerHttpSecurity.AuthorizeExchangeSpec, Unit> get$spring_security_config() {
        return (Function1)new Function1<ServerHttpSecurity.AuthorizeExchangeSpec, Unit>(this){
            final /* synthetic */ AuthorizeExchangeDsl this$0;

            public final void invoke(@NotNull ServerHttpSecurity.AuthorizeExchangeSpec requests) {
                Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
                Iterable $this$forEach$iv = AuthorizeExchangeDsl.access$getAuthorizationRules$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ExchangeAuthorizationRule rule = (ExchangeAuthorizationRule)element$iv;
                    boolean bl = false;
                    ExchangeAuthorizationRule exchangeAuthorizationRule = rule;
                    if (exchangeAuthorizationRule instanceof MatcherExchangeAuthorizationRule) {
                        ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)requests.matchers(((MatcherExchangeAuthorizationRule)rule).getMatcher())).access(rule.getRule());
                        continue;
                    }
                    if (!(exchangeAuthorizationRule instanceof PatternExchangeAuthorizationRule)) continue;
                    ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)requests.pathMatchers(((PatternExchangeAuthorizationRule)rule).getPattern())).access(rule.getRule());
                }
            }
            {
                this.this$0 = authorizeExchangeDsl;
                super(1);
            }
        };
    }

    public AuthorizeExchangeDsl() {
        boolean bl = false;
        this.authorizationRules = new ArrayList();
        ServerWebExchangeMatcher serverWebExchangeMatcher = ServerWebExchangeMatchers.anyExchange();
        Intrinsics.checkNotNullExpressionValue((Object)serverWebExchangeMatcher, (String)"ServerWebExchangeMatchers.anyExchange()");
        this.anyExchange = serverWebExchangeMatcher;
        this.permitAll = permitAll.1.INSTANCE;
        this.denyAll = denyAll.1.INSTANCE;
        AuthenticatedReactiveAuthorizationManager authenticatedReactiveAuthorizationManager = AuthenticatedReactiveAuthorizationManager.authenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authenticatedReactiveAuthorizationManager, (String)"AuthenticatedReactiveAut\u2026d<AuthorizationContext>()");
        this.authenticated = (ReactiveAuthorizationManager)authenticatedReactiveAuthorizationManager;
    }

    public static final /* synthetic */ List access$getAuthorizationRules$p(AuthorizeExchangeDsl $this) {
        return $this.authorizationRules;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$MatcherExchangeAuthorizationRule;", "Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "matcher", "Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "rule", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "(Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;Lorg/springframework/security/authorization/ReactiveAuthorizationManager;)V", "getMatcher", "()Lorg/springframework/security/web/server/util/matcher/ServerWebExchangeMatcher;", "getRule", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "spring-security-config"})
    private static final class MatcherExchangeAuthorizationRule
    extends ExchangeAuthorizationRule {
        @NotNull
        private final ServerWebExchangeMatcher matcher;
        @NotNull
        private final ReactiveAuthorizationManager<AuthorizationContext> rule;

        @NotNull
        public final ServerWebExchangeMatcher getMatcher() {
            return this.matcher;
        }

        @Override
        @NotNull
        public ReactiveAuthorizationManager<AuthorizationContext> getRule() {
            return this.rule;
        }

        public MatcherExchangeAuthorizationRule(@NotNull ServerWebExchangeMatcher matcher, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            super(rule);
            this.matcher = matcher;
            this.rule = rule;
        }

        @NotNull
        public final ServerWebExchangeMatcher component1() {
            return this.matcher;
        }

        @NotNull
        public final ReactiveAuthorizationManager<AuthorizationContext> component2() {
            return this.getRule();
        }

        @NotNull
        public final MatcherExchangeAuthorizationRule copy(@NotNull ServerWebExchangeMatcher matcher, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            return new MatcherExchangeAuthorizationRule(matcher, rule);
        }

        public static /* synthetic */ MatcherExchangeAuthorizationRule copy$default(MatcherExchangeAuthorizationRule matcherExchangeAuthorizationRule, ServerWebExchangeMatcher serverWebExchangeMatcher, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
            if ((n & 1) != 0) {
                serverWebExchangeMatcher = matcherExchangeAuthorizationRule.matcher;
            }
            if ((n & 2) != 0) {
                reactiveAuthorizationManager = matcherExchangeAuthorizationRule.getRule();
            }
            return matcherExchangeAuthorizationRule.copy(serverWebExchangeMatcher, reactiveAuthorizationManager);
        }

        @NotNull
        public String toString() {
            return "MatcherExchangeAuthorizationRule(matcher=" + this.matcher + ", rule=" + this.getRule() + ")";
        }

        public int hashCode() {
            ServerWebExchangeMatcher serverWebExchangeMatcher = this.matcher;
            ReactiveAuthorizationManager<AuthorizationContext> reactiveAuthorizationManager = this.getRule();
            return (serverWebExchangeMatcher != null ? serverWebExchangeMatcher.hashCode() : 0) * 31 + (reactiveAuthorizationManager != null ? reactiveAuthorizationManager.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MatcherExchangeAuthorizationRule)) break block3;
                    MatcherExchangeAuthorizationRule matcherExchangeAuthorizationRule = (MatcherExchangeAuthorizationRule)object;
                    if (!Intrinsics.areEqual((Object)this.matcher, (Object)matcherExchangeAuthorizationRule.matcher) || !Intrinsics.areEqual(this.getRule(), matcherExchangeAuthorizationRule.getRule())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$PatternExchangeAuthorizationRule;", "Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "pattern", "", "rule", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "(Ljava/lang/String;Lorg/springframework/security/authorization/ReactiveAuthorizationManager;)V", "getPattern", "()Ljava/lang/String;", "getRule", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "spring-security-config"})
    private static final class PatternExchangeAuthorizationRule
    extends ExchangeAuthorizationRule {
        @NotNull
        private final String pattern;
        @NotNull
        private final ReactiveAuthorizationManager<AuthorizationContext> rule;

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @Override
        @NotNull
        public ReactiveAuthorizationManager<AuthorizationContext> getRule() {
            return this.rule;
        }

        public PatternExchangeAuthorizationRule(@NotNull String pattern, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            super(rule);
            this.pattern = pattern;
            this.rule = rule;
        }

        @NotNull
        public final String component1() {
            return this.pattern;
        }

        @NotNull
        public final ReactiveAuthorizationManager<AuthorizationContext> component2() {
            return this.getRule();
        }

        @NotNull
        public final PatternExchangeAuthorizationRule copy(@NotNull String pattern, @NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            return new PatternExchangeAuthorizationRule(pattern, rule);
        }

        public static /* synthetic */ PatternExchangeAuthorizationRule copy$default(PatternExchangeAuthorizationRule patternExchangeAuthorizationRule, String string, ReactiveAuthorizationManager reactiveAuthorizationManager, int n, Object object) {
            if ((n & 1) != 0) {
                string = patternExchangeAuthorizationRule.pattern;
            }
            if ((n & 2) != 0) {
                reactiveAuthorizationManager = patternExchangeAuthorizationRule.getRule();
            }
            return patternExchangeAuthorizationRule.copy(string, reactiveAuthorizationManager);
        }

        @NotNull
        public String toString() {
            return "PatternExchangeAuthorizationRule(pattern=" + this.pattern + ", rule=" + this.getRule() + ")";
        }

        public int hashCode() {
            String string = this.pattern;
            ReactiveAuthorizationManager<AuthorizationContext> reactiveAuthorizationManager = this.getRule();
            return (string != null ? string.hashCode() : 0) * 31 + (reactiveAuthorizationManager != null ? reactiveAuthorizationManager.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PatternExchangeAuthorizationRule)) break block3;
                    PatternExchangeAuthorizationRule patternExchangeAuthorizationRule = (PatternExchangeAuthorizationRule)object;
                    if (!Intrinsics.areEqual((Object)this.pattern, (Object)patternExchangeAuthorizationRule.pattern) || !Intrinsics.areEqual(this.getRule(), patternExchangeAuthorizationRule.getRule())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/springframework/security/config/web/server/AuthorizeExchangeDsl$ExchangeAuthorizationRule;", "", "rule", "Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "Lorg/springframework/security/web/server/authorization/AuthorizationContext;", "(Lorg/springframework/security/authorization/ReactiveAuthorizationManager;)V", "getRule", "()Lorg/springframework/security/authorization/ReactiveAuthorizationManager;", "spring-security-config"})
    private static abstract class ExchangeAuthorizationRule {
        @NotNull
        private final ReactiveAuthorizationManager<AuthorizationContext> rule;

        @NotNull
        public ReactiveAuthorizationManager<AuthorizationContext> getRule() {
            return this.rule;
        }

        public ExchangeAuthorizationRule(@NotNull ReactiveAuthorizationManager<AuthorizationContext> rule) {
            Intrinsics.checkNotNullParameter(rule, (String)"rule");
            this.rule = rule;
        }
    }
}

