/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.OrderComparator;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.authentication.AuthenticationManagerFactoryBean;
import org.springframework.security.config.http.AuthenticationConfigBuilder;
import org.springframework.security.config.http.ClearCredentialsMethodInvokingFactoryBean;
import org.springframework.security.config.http.DefaultFilterChainValidator;
import org.springframework.security.config.http.HttpConfigurationBuilder;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.PortMappingsBeanDefinitionParser;
import org.springframework.security.config.http.RequestRejectedHandlerPostProcessor;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Log logger = LogFactory.getLog(HttpSecurityBeanDefinitionParser.class);
    private static final String ATT_AUTHENTICATION_MANAGER_REF = "authentication-manager-ref";
    static final String ATT_REQUEST_MATCHER_REF = "request-matcher-ref";
    static final String ATT_PATH_PATTERN = "pattern";
    static final String ATT_HTTP_METHOD = "method";
    static final String ATT_FILTERS = "filters";
    static final String OPT_FILTERS_NONE = "none";
    static final String ATT_REQUIRES_CHANNEL = "requires-channel";
    private static final String ATT_REF = "ref";
    private static final String ATT_SECURED = "security";
    private static final String OPT_SECURITY_NONE = "none";

    public BeanDefinition parse(Element element, ParserContext pc) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        HttpSecurityBeanDefinitionParser.registerFilterChainProxyIfNecessary(pc, pc.extractSource((Object)element));
        BeanDefinition listFactoryBean = pc.getRegistry().getBeanDefinition("org.springframework.security.filterChains");
        List filterChains = (List)listFactoryBean.getPropertyValues().getPropertyValue("sourceList").getValue();
        filterChains.add(this.createFilterChain(element, pc));
        pc.popAndRegisterContainingComponent();
        return null;
    }

    private BeanReference createFilterChain(Element element, ParserContext pc) {
        boolean secured;
        boolean bl = secured = !"none".equals(element.getAttribute(ATT_SECURED));
        if (!secured) {
            if (!StringUtils.hasText((String)element.getAttribute(ATT_PATH_PATTERN)) && !StringUtils.hasText((String)ATT_REQUEST_MATCHER_REF)) {
                pc.getReaderContext().error("The 'security' attribute must be used in combination with the 'pattern' or 'request-matcher-ref' attributes.", pc.extractSource((Object)element));
            }
            for (int n = 0; n < element.getChildNodes().getLength(); ++n) {
                if (!(element.getChildNodes().item(n) instanceof Element)) continue;
                pc.getReaderContext().error("If you are using <http> to define an unsecured pattern, it cannot contain child elements.", pc.extractSource((Object)element));
            }
            return this.createSecurityFilterChainBean(element, pc, Collections.emptyList());
        }
        BeanReference portMapper = this.createPortMapper(element, pc);
        RuntimeBeanReference portResolver = this.createPortResolver(portMapper, pc);
        ManagedList authenticationProviders = new ManagedList();
        BeanReference authenticationManager = this.createAuthenticationManager(element, pc, (ManagedList<BeanReference>)authenticationProviders);
        boolean forceAutoConfig = HttpSecurityBeanDefinitionParser.isDefaultHttpConfig(element);
        HttpConfigurationBuilder httpBldr = new HttpConfigurationBuilder(element, forceAutoConfig, pc, portMapper, (BeanReference)portResolver, authenticationManager);
        AuthenticationConfigBuilder authBldr = new AuthenticationConfigBuilder(element, forceAutoConfig, pc, httpBldr.getSessionCreationPolicy(), httpBldr.getRequestCache(), authenticationManager, httpBldr.getSessionStrategy(), portMapper, (BeanReference)portResolver, httpBldr.getCsrfLogoutHandler());
        httpBldr.setLogoutHandlers(authBldr.getLogoutHandlers());
        httpBldr.setEntryPoint(authBldr.getEntryPointBean());
        httpBldr.setAccessDeniedHandler(authBldr.getAccessDeniedHandlerBean());
        httpBldr.setCsrfIgnoreRequestMatchers(authBldr.getCsrfIgnoreRequestMatchers());
        authenticationProviders.addAll(authBldr.getProviders());
        ArrayList<OrderDecorator> unorderedFilterChain = new ArrayList<OrderDecorator>();
        unorderedFilterChain.addAll(httpBldr.getFilters());
        unorderedFilterChain.addAll(authBldr.getFilters());
        unorderedFilterChain.addAll(this.buildCustomFilterList(element, pc));
        unorderedFilterChain.sort((Comparator<OrderDecorator>)new OrderComparator());
        this.checkFilterChainOrder(unorderedFilterChain, pc, pc.extractSource((Object)element));
        ManagedList filterChain = new ManagedList();
        for (OrderDecorator od : unorderedFilterChain) {
            filterChain.add(od.bean);
        }
        return this.createSecurityFilterChainBean(element, pc, (List<?>)filterChain);
    }

    private static boolean isDefaultHttpConfig(Element httpElt) {
        return httpElt.getChildNodes().getLength() == 0 && httpElt.getAttributes().getLength() == 0;
    }

    private BeanReference createSecurityFilterChainBean(Element element, ParserContext pc, List<?> filterChain) {
        Object filterChainMatcher;
        String requestMatcherRef = element.getAttribute(ATT_REQUEST_MATCHER_REF);
        String filterChainPattern = element.getAttribute(ATT_PATH_PATTERN);
        if (StringUtils.hasText((String)requestMatcherRef)) {
            if (StringUtils.hasText((String)filterChainPattern)) {
                pc.getReaderContext().error("You can't define a pattern and a request-matcher-ref for the same filter chain", pc.extractSource((Object)element));
            }
            filterChainMatcher = new RuntimeBeanReference(requestMatcherRef);
        } else {
            filterChainMatcher = StringUtils.hasText((String)filterChainPattern) ? MatcherType.fromElement(element).createMatcher(pc, filterChainPattern, null) : new RootBeanDefinition(AnyRequestMatcher.class);
        }
        BeanDefinitionBuilder filterChainBldr = BeanDefinitionBuilder.rootBeanDefinition(DefaultSecurityFilterChain.class);
        filterChainBldr.addConstructorArgValue(filterChainMatcher);
        filterChainBldr.addConstructorArgValue(filterChain);
        AbstractBeanDefinition filterChainBean = filterChainBldr.getBeanDefinition();
        String id = element.getAttribute("name");
        if (!StringUtils.hasText((String)id) && !StringUtils.hasText((String)(id = element.getAttribute("id")))) {
            id = pc.getReaderContext().generateBeanName((BeanDefinition)filterChainBean);
        }
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)filterChainBean, id));
        return new RuntimeBeanReference(id);
    }

    private BeanReference createPortMapper(Element elt, ParserContext pc) {
        BeanDefinition portMapper = new PortMappingsBeanDefinitionParser().parse(DomUtils.getChildElementByTagName((Element)elt, (String)"port-mappings"), pc);
        String portMapperName = pc.getReaderContext().generateBeanName(portMapper);
        pc.registerBeanComponent(new BeanComponentDefinition(portMapper, portMapperName));
        return new RuntimeBeanReference(portMapperName);
    }

    private RuntimeBeanReference createPortResolver(BeanReference portMapper, ParserContext pc) {
        RootBeanDefinition portResolver = new RootBeanDefinition(PortResolverImpl.class);
        portResolver.getPropertyValues().addPropertyValue("portMapper", (Object)portMapper);
        String portResolverName = pc.getReaderContext().generateBeanName((BeanDefinition)portResolver);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)portResolver, portResolverName));
        return new RuntimeBeanReference(portResolverName);
    }

    private BeanReference createAuthenticationManager(Element element, ParserContext pc, ManagedList<BeanReference> authenticationProviders) {
        String parentMgrRef = element.getAttribute(ATT_AUTHENTICATION_MANAGER_REF);
        BeanDefinitionBuilder authManager = BeanDefinitionBuilder.rootBeanDefinition(ProviderManager.class);
        authManager.addConstructorArgValue(authenticationProviders);
        if (StringUtils.hasText((String)parentMgrRef)) {
            RuntimeBeanReference parentAuthManager = new RuntimeBeanReference(parentMgrRef);
            authManager.addConstructorArgValue((Object)parentAuthManager);
            RootBeanDefinition clearCredentials = new RootBeanDefinition(ClearCredentialsMethodInvokingFactoryBean.class);
            clearCredentials.getPropertyValues().addPropertyValue("targetObject", (Object)parentAuthManager);
            clearCredentials.getPropertyValues().addPropertyValue("targetMethod", (Object)"isEraseCredentialsAfterAuthentication");
            authManager.addPropertyValue("eraseCredentialsAfterAuthentication", (Object)clearCredentials);
        } else {
            RootBeanDefinition amfb = new RootBeanDefinition(AuthenticationManagerFactoryBean.class);
            amfb.setRole(2);
            String amfbId = pc.getReaderContext().generateBeanName((BeanDefinition)amfb);
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)amfb, amfbId));
            RootBeanDefinition clearCredentials = new RootBeanDefinition(MethodInvokingFactoryBean.class);
            clearCredentials.getPropertyValues().addPropertyValue("targetObject", (Object)new RuntimeBeanReference(amfbId));
            clearCredentials.getPropertyValues().addPropertyValue("targetMethod", (Object)"isEraseCredentialsAfterAuthentication");
            authManager.addConstructorArgValue((Object)new RuntimeBeanReference(amfbId));
            authManager.addPropertyValue("eraseCredentialsAfterAuthentication", (Object)clearCredentials);
        }
        authManager.addPropertyValue("authenticationEventPublisher", (Object)new RootBeanDefinition(DefaultAuthenticationEventPublisher.class));
        authManager.getRawBeanDefinition().setSource(pc.extractSource((Object)element));
        AbstractBeanDefinition authMgrBean = authManager.getBeanDefinition();
        String id = pc.getReaderContext().generateBeanName((BeanDefinition)authMgrBean);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)authMgrBean, id));
        return new RuntimeBeanReference(id);
    }

    private void checkFilterChainOrder(List<OrderDecorator> filters, ParserContext pc, Object source) {
        logger.info((Object)("Checking sorted filter chain: " + filters));
        for (int i2 = 0; i2 < filters.size(); ++i2) {
            OrderDecorator filter = filters.get(i2);
            if (i2 <= 0) continue;
            OrderDecorator previous = filters.get(i2 - 1);
            if (filter.getOrder() != previous.getOrder()) continue;
            pc.getReaderContext().error("Filter beans '" + filter.bean + "' and '" + previous.bean + "' have the same 'order' value. When using custom filters, please make sure the positions do not conflict with default filters. Alternatively you can disable the default filters by removing the corresponding child elements from <http> and avoiding the use of <http auto-config='true'>.", source);
        }
    }

    List<OrderDecorator> buildCustomFilterList(Element element, ParserContext pc) {
        List customFilterElts = DomUtils.getChildElementsByTagName((Element)element, (String)"custom-filter");
        ArrayList<OrderDecorator> customFilters = new ArrayList<OrderDecorator>();
        String ATT_AFTER = "after";
        String ATT_BEFORE = "before";
        String ATT_POSITION = "position";
        for (Element elt : customFilterElts) {
            SecurityFilters order;
            String after = elt.getAttribute("after");
            String before = elt.getAttribute("before");
            String position = elt.getAttribute("position");
            String ref = elt.getAttribute(ATT_REF);
            if (!StringUtils.hasText((String)ref)) {
                pc.getReaderContext().error("The 'ref' attribute must be supplied", pc.extractSource((Object)elt));
            }
            RuntimeBeanReference bean = new RuntimeBeanReference(ref);
            if (WebConfigUtils.countNonEmpty(new String[]{after, before, position}) != 1) {
                pc.getReaderContext().error("A single 'after', 'before', or 'position' attribute must be supplied", pc.extractSource((Object)elt));
            }
            if (StringUtils.hasText((String)position)) {
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.valueOf(position)));
                continue;
            }
            if (StringUtils.hasText((String)after)) {
                order = SecurityFilters.valueOf(after);
                if (order == SecurityFilters.LAST) {
                    customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.LAST));
                    continue;
                }
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, order.getOrder() + 1));
                continue;
            }
            if (!StringUtils.hasText((String)before)) continue;
            order = SecurityFilters.valueOf(before);
            if (order == SecurityFilters.FIRST) {
                customFilters.add(new OrderDecorator((BeanMetadataElement)bean, SecurityFilters.FIRST));
                continue;
            }
            customFilters.add(new OrderDecorator((BeanMetadataElement)bean, order.getOrder() - 1));
        }
        return customFilters;
    }

    static void registerFilterChainProxyIfNecessary(ParserContext pc, Object source) {
        BeanDefinitionRegistry registry = pc.getRegistry();
        if (registry.containsBeanDefinition("org.springframework.security.filterChainProxy")) {
            return;
        }
        RootBeanDefinition listFactoryBean = new RootBeanDefinition(ListFactoryBean.class);
        listFactoryBean.getPropertyValues().add("sourceList", (Object)new ManagedList());
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)listFactoryBean, "org.springframework.security.filterChains"));
        BeanDefinitionBuilder fcpBldr = BeanDefinitionBuilder.rootBeanDefinition(FilterChainProxy.class);
        fcpBldr.getRawBeanDefinition().setSource(source);
        fcpBldr.addConstructorArgReference("org.springframework.security.filterChains");
        fcpBldr.addPropertyValue("filterChainValidator", (Object)new RootBeanDefinition(DefaultFilterChainValidator.class));
        AbstractBeanDefinition fcpBean = fcpBldr.getBeanDefinition();
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)fcpBean, "org.springframework.security.filterChainProxy"));
        registry.registerAlias("org.springframework.security.filterChainProxy", "springSecurityFilterChain");
        BeanDefinitionBuilder requestRejected = BeanDefinitionBuilder.rootBeanDefinition(RequestRejectedHandlerPostProcessor.class);
        requestRejected.setRole(2);
        requestRejected.addConstructorArgValue((Object)"requestRejectedHandler");
        requestRejected.addConstructorArgValue((Object)"org.springframework.security.filterChainProxy");
        requestRejected.addConstructorArgValue((Object)"requestRejectedHandler");
        AbstractBeanDefinition requestRejectedBean = requestRejected.getBeanDefinition();
        String requestRejectedPostProcessorName = pc.getReaderContext().generateBeanName((BeanDefinition)requestRejectedBean);
        registry.registerBeanDefinition(requestRejectedPostProcessorName, (BeanDefinition)requestRejectedBean);
    }
}

