/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.AutowiredWebSecurityConfigurersIgnoreParents;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.crypto.RsaKeyConversionServicePostProcessor;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;

@Configuration(proxyBeanMethods=false)
public class WebSecurityConfiguration
implements ImportAware,
BeanClassLoaderAware {
    private WebSecurity webSecurity;
    private Boolean debugEnabled;
    private List<SecurityConfigurer<Filter, WebSecurity>> webSecurityConfigurers;
    private List<SecurityFilterChain> securityFilterChains = Collections.emptyList();
    private ClassLoader beanClassLoader;
    @Autowired(required=false)
    private ObjectPostProcessor<Object> objectObjectPostProcessor;

    @Bean
    public static DelegatingApplicationListener delegatingApplicationListener() {
        return new DelegatingApplicationListener();
    }

    @Bean
    @DependsOn(value={"springSecurityFilterChain"})
    public SecurityExpressionHandler<FilterInvocation> webSecurityExpressionHandler() {
        return this.webSecurity.getExpressionHandler();
    }

    @Bean(name={"springSecurityFilterChain"})
    public Filter springSecurityFilterChain() throws Exception {
        boolean hasFilterChain;
        boolean hasConfigurers = this.webSecurityConfigurers != null && !this.webSecurityConfigurers.isEmpty();
        boolean bl = hasFilterChain = !this.securityFilterChains.isEmpty();
        if (hasConfigurers && hasFilterChain) {
            throw new IllegalStateException("Found WebSecurityConfigurerAdapter as well as SecurityFilterChain.Please select just one.");
        }
        if (!hasConfigurers && !hasFilterChain) {
            WebSecurityConfigurerAdapter adapter = this.objectObjectPostProcessor.postProcess(new WebSecurityConfigurerAdapter(){});
            this.webSecurity.apply(adapter);
        }
        block0: for (SecurityFilterChain securityFilterChain : this.securityFilterChains) {
            this.webSecurity.addSecurityFilterChainBuilder(() -> securityFilterChain);
            for (Filter filter : securityFilterChain.getFilters()) {
                if (!(filter instanceof FilterSecurityInterceptor)) continue;
                this.webSecurity.securityInterceptor((FilterSecurityInterceptor)filter);
                continue block0;
            }
        }
        return (Filter)this.webSecurity.build();
    }

    @Bean
    @DependsOn(value={"springSecurityFilterChain"})
    public WebInvocationPrivilegeEvaluator privilegeEvaluator() {
        return this.webSecurity.getPrivilegeEvaluator();
    }

    @Autowired(required=false)
    public void setFilterChainProxySecurityConfigurer(ObjectPostProcessor<Object> objectPostProcessor, @Value(value="#{@autowiredWebSecurityConfigurersIgnoreParents.getWebSecurityConfigurers()}") List<SecurityConfigurer<Filter, WebSecurity>> webSecurityConfigurers) throws Exception {
        this.webSecurity = objectPostProcessor.postProcess(new WebSecurity(objectPostProcessor));
        if (this.debugEnabled != null) {
            this.webSecurity.debug(this.debugEnabled);
        }
        webSecurityConfigurers.sort((Comparator<SecurityConfigurer<Filter, WebSecurity>>)((Object)AnnotationAwareOrderComparator.INSTANCE));
        Integer previousOrder = null;
        SecurityConfigurer<Filter, WebSecurity> previousConfig = null;
        for (SecurityConfigurer<Filter, WebSecurity> config : webSecurityConfigurers) {
            Integer order = AnnotationAwareOrderComparator.lookupOrder(config);
            if (previousOrder != null && previousOrder.equals(order)) {
                throw new IllegalStateException("@Order on WebSecurityConfigurers must be unique. Order of " + order + " was already used on " + previousConfig + ", so it cannot be used on " + config + " too.");
            }
            previousOrder = order;
            previousConfig = config;
        }
        for (SecurityConfigurer<Filter, WebSecurity> webSecurityConfigurer : webSecurityConfigurers) {
            this.webSecurity.apply(webSecurityConfigurer);
        }
        this.webSecurityConfigurers = webSecurityConfigurers;
    }

    @Autowired(required=false)
    void setFilterChains(List<SecurityFilterChain> securityFilterChains) {
        securityFilterChains.sort((Comparator<SecurityFilterChain>)((Object)AnnotationAwareOrderComparator.INSTANCE));
        this.securityFilterChains = securityFilterChains;
    }

    @Bean
    public static BeanFactoryPostProcessor conversionServicePostProcessor() {
        return new RsaKeyConversionServicePostProcessor();
    }

    @Bean
    public static AutowiredWebSecurityConfigurersIgnoreParents autowiredWebSecurityConfigurersIgnoreParents(ConfigurableListableBeanFactory beanFactory) {
        return new AutowiredWebSecurityConfigurersIgnoreParents(beanFactory);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableWebSecurityAttrMap = importMetadata.getAnnotationAttributes(EnableWebSecurity.class.getName());
        AnnotationAttributes enableWebSecurityAttrs = AnnotationAttributes.fromMap((Map)enableWebSecurityAttrMap);
        this.debugEnabled = enableWebSecurityAttrs.getBoolean("debug");
        if (this.webSecurity != null) {
            this.webSecurity.debug(this.debugEnabled);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    private static class AnnotationAwareOrderComparator
    extends OrderComparator {
        private static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

        private AnnotationAwareOrderComparator() {
        }

        protected int getOrder(Object obj) {
            return AnnotationAwareOrderComparator.lookupOrder(obj);
        }

        private static int lookupOrder(Object obj) {
            Class<?> clazz;
            Order order;
            if (obj instanceof Ordered) {
                return ((Ordered)obj).getOrder();
            }
            if (obj != null && (order = (Order)AnnotationUtils.findAnnotation(clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass(), Order.class)) != null) {
                return order.value();
            }
            return Integer.MAX_VALUE;
        }
    }
}

