/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.message;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.security.access.vote.ConsensusBased;
import org.springframework.security.messaging.access.expression.ExpressionBasedMessageSecurityMetadataSourceFactory;
import org.springframework.security.messaging.access.expression.MessageExpressionVoter;
import org.springframework.security.messaging.access.intercept.ChannelSecurityInterceptor;
import org.springframework.security.messaging.context.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.messaging.context.SecurityContextChannelInterceptor;
import org.springframework.security.messaging.util.matcher.SimpDestinationMessageMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class MessageSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Log logger = LogFactory.getLog(MessageSecurityBeanDefinitionParser.class);
    private static final String ID_ATTR = "id";
    private static final String PATTERN_ATTR = "pattern";
    private static final String ACCESS_ATTR = "access";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        XmlReaderContext context = parserContext.getReaderContext();
        ManagedMap matcherToExpression = new ManagedMap();
        String id = element.getAttribute(ID_ATTR);
        List interceptMessages = DomUtils.getChildElementsByTagName((Element)element, (String)"message-interceptor");
        for (Element interceptMessage : interceptMessages) {
            String matcherPattern = interceptMessage.getAttribute(PATTERN_ATTR);
            String accessExpression = interceptMessage.getAttribute(ACCESS_ATTR);
            BeanDefinitionBuilder matcher = BeanDefinitionBuilder.rootBeanDefinition(SimpDestinationMessageMatcher.class);
            matcher.addConstructorArgValue((Object)matcherPattern);
            matcherToExpression.put((Object)matcher.getBeanDefinition(), (Object)accessExpression);
        }
        BeanDefinitionBuilder mds = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedMessageSecurityMetadataSourceFactory.class);
        mds.setFactoryMethod("createExpressionMessageMetadataSource");
        mds.addConstructorArgValue((Object)matcherToExpression);
        String mdsId = context.registerWithGeneratedName((BeanDefinition)mds.getBeanDefinition());
        ManagedList voters = new ManagedList();
        voters.add((Object)new RootBeanDefinition(MessageExpressionVoter.class));
        BeanDefinitionBuilder adm = BeanDefinitionBuilder.rootBeanDefinition(ConsensusBased.class);
        adm.addConstructorArgValue((Object)voters);
        BeanDefinitionBuilder inboundChannelSecurityInterceptor = BeanDefinitionBuilder.rootBeanDefinition(ChannelSecurityInterceptor.class);
        inboundChannelSecurityInterceptor.addConstructorArgValue((Object)registry.getBeanDefinition(mdsId));
        inboundChannelSecurityInterceptor.addPropertyValue("accessDecisionManager", (Object)adm.getBeanDefinition());
        String inSecurityInterceptorName = context.registerWithGeneratedName((BeanDefinition)inboundChannelSecurityInterceptor.getBeanDefinition());
        if (StringUtils.hasText((String)id)) {
            registry.registerAlias(inSecurityInterceptorName, id);
        } else {
            BeanDefinitionBuilder mspp = BeanDefinitionBuilder.rootBeanDefinition(MessageSecurityPostProcessor.class);
            mspp.addConstructorArgValue((Object)inSecurityInterceptorName);
            context.registerWithGeneratedName((BeanDefinition)mspp.getBeanDefinition());
        }
        return null;
    }

    static class MessageSecurityPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final String CLIENT_INBOUND_CHANNEL_BEAN_ID = "clientInboundChannel";
        private static final String INTERCEPTORS_PROP = "interceptors";
        private static final String CUSTOM_ARG_RESOLVERS_PROP = "customArgumentResolvers";
        private final String inboundSecurityInterceptorId;

        public MessageSecurityPostProcessor(String inboundSecurityInterceptorId) {
            this.inboundSecurityInterceptorId = inboundSecurityInterceptorId;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            String[] beanNames;
            for (String beanName : beanNames = registry.getBeanDefinitionNames()) {
                BeanDefinition bd = registry.getBeanDefinition(beanName);
                if (!bd.getBeanClassName().equals(SimpAnnotationMethodMessageHandler.class.getName())) continue;
                PropertyValue current = bd.getPropertyValues().getPropertyValue(CUSTOM_ARG_RESOLVERS_PROP);
                ManagedList argResolvers = new ManagedList();
                if (current != null) {
                    argResolvers.addAll((Collection)((ManagedList)current.getValue()));
                }
                argResolvers.add((Object)new RootBeanDefinition(AuthenticationPrincipalArgumentResolver.class));
                bd.getPropertyValues().add(CUSTOM_ARG_RESOLVERS_PROP, (Object)argResolvers);
            }
            if (!registry.containsBeanDefinition(CLIENT_INBOUND_CHANNEL_BEAN_ID)) {
                return;
            }
            ManagedList interceptors = new ManagedList();
            interceptors.add((Object)new RootBeanDefinition(SecurityContextChannelInterceptor.class));
            interceptors.add((Object)registry.getBeanDefinition(this.inboundSecurityInterceptorId));
            BeanDefinition inboundChannel = registry.getBeanDefinition(CLIENT_INBOUND_CHANNEL_BEAN_ID);
            PropertyValue currentInterceptorsPv = inboundChannel.getPropertyValues().getPropertyValue(INTERCEPTORS_PROP);
            if (currentInterceptorsPv != null) {
                ManagedList currentInterceptors = (ManagedList)currentInterceptorsPv.getValue();
                interceptors.addAll((Collection)currentInterceptors);
            }
            inboundChannel.getPropertyValues().add(INTERCEPTORS_PROP, (Object)interceptors);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

