/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.header.writers.CacheControlHeadersWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.security.web.header.writers.XContentTypeOptionsHeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.header.writers.frameoptions.RegExpAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.StaticAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.WhiteListedAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.XFrameOptionsHeaderWriter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HeadersBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_ENABLED = "enabled";
    private static final String ATT_BLOCK = "block";
    private static final String ATT_POLICY = "policy";
    private static final String ATT_STRATEGY = "strategy";
    private static final String ATT_FROM_PARAMETER = "from-parameter";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";
    private static final String ATT_REF = "ref";
    private static final String ATT_INCLUDE_SUBDOMAINS = "include-subdomains";
    private static final String ATT_MAX_AGE_SECONDS = "max-age-seconds";
    private static final String ATT_REQUEST_MATCHER_REF = "request-matcher-ref";
    private static final String CACHE_CONTROL_ELEMENT = "cache-control";
    private static final String HSTS_ELEMENT = "hsts";
    private static final String XSS_ELEMENT = "xss-protection";
    private static final String CONTENT_TYPE_ELEMENT = "content-type-options";
    private static final String FRAME_OPTIONS_ELEMENT = "frame-options";
    private static final String GENERIC_HEADER_ELEMENT = "header";
    private static final String ALLOW_FROM = "ALLOW-FROM";
    private ManagedList<BeanMetadataElement> headerWriters;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean disabled;
        this.headerWriters = new ManagedList();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(HeaderWriterFilter.class);
        if (element != null) {
            this.parseCacheControlElement(element);
            this.parseHstsElement(element);
            this.parseXssElement(element, parserContext);
            this.parseFrameOptionsElement(element, parserContext);
            this.parseContentTypeOptionsElement(element);
            this.parseHeaderElements(element);
        }
        boolean bl = disabled = element != null && "true".equals(element.getAttribute("disabled"));
        if (disabled) {
            if (!this.headerWriters.isEmpty()) {
                parserContext.getReaderContext().error("Cannot specify <headers disabled=\"true\"> with child elements.", (Object)element);
            }
            return null;
        }
        if (this.headerWriters.isEmpty()) {
            this.addCacheControl();
            this.addHsts(null);
            this.addContentTypeOptions();
            BeanDefinitionBuilder frameOptions = BeanDefinitionBuilder.genericBeanDefinition(XFrameOptionsHeaderWriter.class);
            frameOptions.addConstructorArgValue((Object)"DENY");
            this.headerWriters.add((Object)frameOptions.getBeanDefinition());
            BeanDefinitionBuilder xss = BeanDefinitionBuilder.genericBeanDefinition(XXssProtectionHeaderWriter.class);
            this.headerWriters.add((Object)xss.getBeanDefinition());
        }
        builder.addConstructorArgValue(this.headerWriters);
        return builder.getBeanDefinition();
    }

    private void parseCacheControlElement(Element element) {
        Element cacheControlElement = DomUtils.getChildElementByTagName((Element)element, (String)CACHE_CONTROL_ELEMENT);
        if (cacheControlElement != null) {
            this.addCacheControl();
        }
    }

    private void addCacheControl() {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(CacheControlHeadersWriter.class);
        this.headerWriters.add((Object)headersWriter.getBeanDefinition());
    }

    private void parseHstsElement(Element element) {
        Element hstsElement = DomUtils.getChildElementByTagName((Element)element, (String)HSTS_ELEMENT);
        if (hstsElement != null) {
            this.addHsts(hstsElement);
        }
    }

    private void addHsts(Element hstsElement) {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(HstsHeaderWriter.class);
        if (hstsElement != null) {
            String requestMatcherRef;
            String maxAgeSeconds;
            String includeSubDomains = hstsElement.getAttribute(ATT_INCLUDE_SUBDOMAINS);
            if (StringUtils.hasText((String)includeSubDomains)) {
                headersWriter.addPropertyValue("includeSubDomains", (Object)includeSubDomains);
            }
            if (StringUtils.hasText((String)(maxAgeSeconds = hstsElement.getAttribute(ATT_MAX_AGE_SECONDS)))) {
                headersWriter.addPropertyValue("maxAgeInSeconds", (Object)maxAgeSeconds);
            }
            if (StringUtils.hasText((String)(requestMatcherRef = hstsElement.getAttribute(ATT_REQUEST_MATCHER_REF)))) {
                headersWriter.addPropertyReference("requestMatcher", requestMatcherRef);
            }
        }
        this.headerWriters.add((Object)headersWriter.getBeanDefinition());
    }

    private void parseHeaderElements(Element element) {
        List headerElts = DomUtils.getChildElementsByTagName((Element)element, (String)GENERIC_HEADER_ELEMENT);
        for (Element headerElt : headerElts) {
            String headerFactoryRef = headerElt.getAttribute(ATT_REF);
            if (StringUtils.hasText((String)headerFactoryRef)) {
                this.headerWriters.add((Object)new RuntimeBeanReference(headerFactoryRef));
                continue;
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticHeadersWriter.class);
            builder.addConstructorArgValue((Object)headerElt.getAttribute(ATT_NAME));
            builder.addConstructorArgValue((Object)headerElt.getAttribute(ATT_VALUE));
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private void parseContentTypeOptionsElement(Element element) {
        Element contentTypeElt = DomUtils.getChildElementByTagName((Element)element, (String)CONTENT_TYPE_ELEMENT);
        if (contentTypeElt != null) {
            this.addContentTypeOptions();
        }
    }

    private void addContentTypeOptions() {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XContentTypeOptionsHeaderWriter.class);
        this.headerWriters.add((Object)builder.getBeanDefinition());
    }

    private void parseFrameOptionsElement(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XFrameOptionsHeaderWriter.class);
        Element frameElt = DomUtils.getChildElementByTagName((Element)element, (String)FRAME_OPTIONS_ELEMENT);
        if (frameElt != null) {
            String header = this.getAttribute(frameElt, ATT_POLICY, "DENY");
            if (ALLOW_FROM.equals(header)) {
                String strategyRef = this.getAttribute(frameElt, ATT_REF, null);
                String strategy = this.getAttribute(frameElt, ATT_STRATEGY, null);
                if (StringUtils.hasText((String)strategy) && StringUtils.hasText((String)strategyRef)) {
                    parserContext.getReaderContext().error("Only one of 'strategy' or 'strategy-ref' can be set.", (Object)frameElt);
                } else if (strategyRef != null) {
                    builder.addConstructorArgReference(strategyRef);
                } else if (strategy != null) {
                    String value = this.getAttribute(frameElt, ATT_VALUE, null);
                    if (!StringUtils.hasText((String)value)) {
                        parserContext.getReaderContext().error("Strategy requires a 'value' to be set.", (Object)frameElt);
                    }
                    if ("static".equals(strategy)) {
                        try {
                            builder.addConstructorArgValue((Object)new StaticAllowFromStrategy(new URI(value)));
                        }
                        catch (URISyntaxException e) {
                            parserContext.getReaderContext().error("'value' attribute doesn't represent a valid URI.", (Object)frameElt, (Throwable)e);
                        }
                    } else {
                        BeanDefinitionBuilder allowFromStrategy;
                        if ("whitelist".equals(strategy)) {
                            allowFromStrategy = BeanDefinitionBuilder.rootBeanDefinition(WhiteListedAllowFromStrategy.class);
                            allowFromStrategy.addConstructorArgValue((Object)StringUtils.commaDelimitedListToSet((String)value));
                        } else {
                            allowFromStrategy = BeanDefinitionBuilder.rootBeanDefinition(RegExpAllowFromStrategy.class);
                            allowFromStrategy.addConstructorArgValue((Object)value);
                        }
                        String fromParameter = this.getAttribute(frameElt, ATT_FROM_PARAMETER, "from");
                        allowFromStrategy.addPropertyValue("allowFromParameterName", (Object)fromParameter);
                        builder.addConstructorArgValue((Object)allowFromStrategy.getBeanDefinition());
                    }
                } else {
                    parserContext.getReaderContext().error("One of 'strategy' and 'strategy-ref' must be set.", (Object)frameElt);
                }
            } else {
                builder.addConstructorArgValue((Object)header);
            }
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private void parseXssElement(Element element, ParserContext parserContext) {
        Element xssElt = DomUtils.getChildElementByTagName((Element)element, (String)XSS_ELEMENT);
        if (xssElt != null) {
            String enabled = xssElt.getAttribute(ATT_ENABLED);
            String block = xssElt.getAttribute(ATT_BLOCK);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XXssProtectionHeaderWriter.class);
            if (StringUtils.hasText((String)enabled)) {
                builder.addPropertyValue(ATT_ENABLED, (Object)enabled);
            }
            if (StringUtils.hasText((String)block)) {
                builder.addPropertyValue(ATT_BLOCK, (Object)block);
            }
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private String getAttribute(Element element, String name, String defaultValue) {
        String value = element.getAttribute(name);
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return defaultValue;
    }
}

