/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Ordered;
import org.springframework.security.config.ConfigUtils;
import org.springframework.security.web.FilterChainOrder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OrderedFilterBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    public static final String ATT_AFTER = "after";
    public static final String ATT_BEFORE = "before";
    public static final String ATT_POSITION = "position";

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder holder, ParserContext parserContext) {
        Element elt = (Element)node;
        String order = this.getOrder(elt, parserContext);
        BeanDefinitionBuilder wrapper = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.config.OrderedFilterBeanDefinitionDecorator$OrderedFilterDecorator");
        wrapper.addConstructorArgValue((Object)holder.getBeanName());
        wrapper.addConstructorArgValue((Object)new RuntimeBeanReference(holder.getBeanName()));
        if (StringUtils.hasText((String)order)) {
            wrapper.addPropertyValue("order", (Object)order);
        }
        ConfigUtils.addHttpFilter(parserContext, (BeanMetadataElement)wrapper.getBeanDefinition());
        return holder;
    }

    private String getOrder(Element elt, ParserContext pc) {
        String position;
        String before;
        String after = elt.getAttribute(ATT_AFTER);
        if (ConfigUtils.countNonEmpty(new String[]{after, before = elt.getAttribute(ATT_BEFORE), position = elt.getAttribute(ATT_POSITION)}) != 1) {
            pc.getReaderContext().error("A single 'after', 'before', or 'position' attribute must be supplied", pc.extractSource((Object)elt));
        }
        if (StringUtils.hasText((String)position)) {
            return Integer.toString(FilterChainOrder.getOrder((String)position));
        }
        if (StringUtils.hasText((String)after)) {
            int order = FilterChainOrder.getOrder((String)after);
            return Integer.toString(order == Integer.MAX_VALUE ? order : order + 1);
        }
        if (StringUtils.hasText((String)before)) {
            int order = FilterChainOrder.getOrder((String)before);
            return Integer.toString(order == Integer.MIN_VALUE ? order : order - 1);
        }
        return null;
    }

    static class OrderedFilterDecorator
    implements Filter,
    Ordered {
        private Integer order = null;
        private Filter delegate;
        private String beanName;

        OrderedFilterDecorator(String beanName, Filter delegate) {
            this.delegate = delegate;
            this.beanName = beanName;
        }

        public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.delegate.doFilter(request, response, chain);
        }

        public final void init(FilterConfig filterConfig) throws ServletException {
            this.delegate.init(filterConfig);
        }

        public final void destroy() {
            this.delegate.destroy();
        }

        public final int getOrder() {
            if (this.order == null) {
                Assert.isInstanceOf(Ordered.class, (Object)this.delegate, (String)("Filter '" + this.beanName + "' must implement the 'Ordered' interface " + " or you must specify one of the attributes '" + OrderedFilterBeanDefinitionDecorator.ATT_AFTER + "' or '" + OrderedFilterBeanDefinitionDecorator.ATT_BEFORE + "' in <" + "custom-filter" + ">"));
                return ((Ordered)this.delegate).getOrder();
            }
            return this.order;
        }

        public final void setOrder(int order) {
            this.order = new Integer(order);
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String toString() {
            return "OrderedFilterDecorator[ delegate=" + this.delegate + "; order=" + this.getOrder() + "]";
        }

        Filter getDelegate() {
            return this.delegate;
        }
    }
}

