/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.afterinvocation;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthorizationServiceException;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.Permission;
import org.springframework.security.afterinvocation.AbstractAclProvider;
import org.springframework.security.afterinvocation.ArrayFilterer;
import org.springframework.security.afterinvocation.CollectionFilterer;

public class AclEntryAfterInvocationCollectionFilteringProvider
extends AbstractAclProvider {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider == null ? (class$org$springframework$security$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider = AclEntryAfterInvocationCollectionFilteringProvider.class$("org.springframework.security.afterinvocation.AclEntryAfterInvocationCollectionFilteringProvider")) : class$org$springframework$security$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider));
    static /* synthetic */ Class class$org$springframework$security$afterinvocation$AclEntryAfterInvocationCollectionFilteringProvider;

    public AclEntryAfterInvocationCollectionFilteringProvider(AclService aclService, Permission[] requirePermission) {
        super(aclService, "AFTER_ACL_COLLECTION_READ", requirePermission);
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Return object is null, skipping");
            }
            return null;
        }
        Iterator iter = config.getConfigAttributes().iterator();
        while (iter.hasNext()) {
            CollectionFilterer filterer;
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            if (returnedObject instanceof Collection) {
                filterer = new CollectionFilterer((Collection)returnedObject);
            } else if (returnedObject.getClass().isArray()) {
                filterer = new ArrayFilterer((Object[])returnedObject);
            } else {
                throw new AuthorizationServiceException("A Collection or an array (or null) was required as the returnedObject, but the returnedObject was: " + returnedObject);
            }
            Iterator collectionIter = filterer.iterator();
            while (collectionIter.hasNext()) {
                Object domainObject = collectionIter.next();
                if (domainObject == null || !this.getProcessDomainObjectClass().isAssignableFrom(domainObject.getClass()) || this.hasPermission(authentication, domainObject)) continue;
                filterer.remove(domainObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Principal is NOT authorised for element: " + domainObject));
            }
            return filterer.getFilteredObject();
        }
        return returnedObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

