/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

abstract class JwkDefinition {
    private final String keyId;
    private final KeyType keyType;
    private final PublicKeyUse publicKeyUse;
    private final CryptoAlgorithm algorithm;

    protected JwkDefinition(String keyId, KeyType keyType, PublicKeyUse publicKeyUse, CryptoAlgorithm algorithm) {
        this.keyId = keyId;
        this.keyType = keyType;
        this.publicKeyUse = publicKeyUse;
        this.algorithm = algorithm;
    }

    String getKeyId() {
        return this.keyId;
    }

    KeyType getKeyType() {
        return this.keyType;
    }

    PublicKeyUse getPublicKeyUse() {
        return this.publicKeyUse;
    }

    CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JwkDefinition that = (JwkDefinition)obj;
        if (!this.getKeyId().equals(that.getKeyId())) {
            return false;
        }
        return this.getKeyType().equals((Object)that.getKeyType());
    }

    public int hashCode() {
        int result = this.getKeyId().hashCode();
        result = 31 * result + this.getKeyType().hashCode();
        return result;
    }

    static enum CryptoAlgorithm {
        RS256("SHA256withRSA", "RS256"),
        RS384("SHA384withRSA", "RS384"),
        RS512("SHA512withRSA", "RS512"),
        ES256("SHA256withECDSA", "ES256"),
        ES384("SHA384withECDSA", "ES384"),
        ES512("SHA512withECDSA", "ES512");

        private final String standardName;
        private final String headerParamValue;

        private CryptoAlgorithm(String standardName, String headerParamValue) {
            this.standardName = standardName;
            this.headerParamValue = headerParamValue;
        }

        String standardName() {
            return this.standardName;
        }

        String headerParamValue() {
            return this.headerParamValue;
        }

        static CryptoAlgorithm fromHeaderParamValue(String headerParamValue) {
            CryptoAlgorithm result = null;
            for (CryptoAlgorithm algorithm : CryptoAlgorithm.values()) {
                if (!algorithm.headerParamValue().equals(headerParamValue)) continue;
                result = algorithm;
                break;
            }
            return result;
        }
    }

    static enum PublicKeyUse {
        SIG("sig"),
        ENC("enc");

        private final String value;

        private PublicKeyUse(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }

        static PublicKeyUse fromValue(String value) {
            PublicKeyUse result = null;
            for (PublicKeyUse publicKeyUse : PublicKeyUse.values()) {
                if (!publicKeyUse.value().equals(value)) continue;
                result = publicKeyUse;
                break;
            }
            return result;
        }
    }

    static enum KeyType {
        RSA("RSA"),
        EC("EC"),
        OCT("oct");

        private final String value;

        private KeyType(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }

        static KeyType fromValue(String value) {
            KeyType result = null;
            for (KeyType keyType : KeyType.values()) {
                if (!keyType.value().equals(value)) continue;
                result = keyType;
                break;
            }
            return result;
        }
    }
}

