/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configuration;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.oauth2.provider.expression.OAuth2WebSecurityExpressionHandler;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
public class ResourceServerConfiguration
extends WebSecurityConfigurerAdapter
implements Ordered {
    private int order = 3;
    @Autowired(required=false)
    private TokenStore tokenStore;
    @Autowired(required=false)
    private ResourceServerTokenServices tokenServices;
    private List<ResourceServerConfigurer> configurers = Collections.emptyList();
    private AccessDeniedHandler accessDeniedHandler = new OAuth2AccessDeniedHandler();
    @Autowired(required=false)
    private AuthorizationServerEndpointsConfiguration endpoints;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Autowired(required=false)
    public void setConfigurers(List<ResourceServerConfigurer> configurers) {
        this.configurers = configurers;
    }

    protected void configure(HttpSecurity http) throws Exception {
        HttpSecurity.RequestMatcherConfigurer requests = http.requestMatchers();
        if (this.endpoints != null) {
            requests.requestMatchers(new RequestMatcher[]{new NotOAuthRequestMatcher(this.endpoints.oauth2EndpointHandlerMapping())});
        }
        ((HttpSecurity)((HttpSecurity)http.exceptionHandling().accessDeniedHandler(this.accessDeniedHandler).and()).anonymous().disable()).csrf().disable();
        for (ResourceServerConfigurer configurer : this.configurers) {
            configurer.configure(http);
        }
        if (this.configurers.isEmpty()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
        http.authorizeRequests().expressionHandler((SecurityExpressionHandler)new OAuth2WebSecurityExpressionHandler());
        ResourceServerSecurityConfigurer resources = new ResourceServerSecurityConfigurer();
        http.apply((SecurityConfigurerAdapter)resources);
        if (this.tokenServices != null) {
            resources.tokenServices(this.tokenServices);
        } else if (this.tokenStore != null) {
            resources.tokenStore(this.tokenStore);
        }
        for (ResourceServerConfigurer configurer : this.configurers) {
            configurer.configure(resources);
        }
    }

    private static class NotOAuthRequestMatcher
    implements RequestMatcher {
        private FrameworkEndpointHandlerMapping mapping;

        public NotOAuthRequestMatcher(FrameworkEndpointHandlerMapping mapping) {
            this.mapping = mapping;
        }

        public boolean matches(HttpServletRequest request) {
            String requestPath = this.getRequestPath(request);
            for (String path : this.mapping.getPaths()) {
                if (!requestPath.startsWith(path)) continue;
                return false;
            }
            return true;
        }

        private String getRequestPath(HttpServletRequest request) {
            String url = request.getServletPath();
            if (request.getPathInfo() != null) {
                url = url + request.getPathInfo();
            }
            return url;
        }
    }
}

